/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.io.File;
import skeletonapplet.JreInfo;
import skeletonapplet.Utilities;

public class PacketTracerLocator {
    protected File homeDirectory;
    protected String defaultHome;
    protected String executableFullName;
    protected String executableString;
    protected String genericOsName;
    protected String pathSeparator;
    protected String pathVariable;
    protected String saveSubDirectory;
    public static final String DEFAULT_ENV_VARS_STRING = "PT_FOR_PTA_PLAYER_DIR,PT_LAUNCH_DIR,PT_INSTALLED_DIR,PTDIR,PT5HOME";
    public static final String DEFAULT_SPECIFIC_DIRS_STRING = "";

    public PacketTracerLocator() {
        this(DEFAULT_ENV_VARS_STRING, DEFAULT_SPECIFIC_DIRS_STRING);
    }

    public PacketTracerLocator(String string, String string2) {
        this.initializeBasedOnOs();
        this.homeDirectory = this.findHomeDirectory(string, string2);
        this.completeInitializationBasedOnOs();
    }

    public String getExecutableString() {
        return this.executableString;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public String getPathVariable() {
        return this.pathVariable;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public File getBinDirectory() {
        return new File(this.homeDirectory, "bin");
    }

    public File getSaveDirectory() {
        return new File(this.homeDirectory, this.saveSubDirectory);
    }

    public boolean executableExists() {
        Utilities.logPrintln("executableExists()");
        if (this.executableString == null) {
            Utilities.logPrintln("??? executableString == null = " + (this.executableString == null));
            Utilities.logPrintln("\n==> false");
            return false;
        }
        File file = new File(this.executableString);
        Utilities.logPrintln("... executable = " + file);
        Utilities.logPrintln("\n==> " + file.exists());
        return file.exists();
    }

    protected void initializeBasedOnOs() {
        Utilities.logPrintln("initializeBasedOnOs()");
        if (Utilities.isLinux()) {
            Utilities.logPrintln("??? Utilities.isLinux() = " + Utilities.isLinux());
            this.initializeForLinux();
        } else if (Utilities.isWindows()) {
            Utilities.logPrintln("??? Utilities.isWindows() = " + Utilities.isWindows());
            this.initializeForWindows();
        } else {
            throw new Error("Your operating system isn't supported by the Packet Tracer Skills Assessment Player.\n\tOperating System Information: " + System.getProperty("os.name", "none"));
        }
        Utilities.logPrintln("\n==> void");
    }

    protected void initializeForLinux() {
        Utilities.logPrintln("()");
        this.defaultHome = "/opt/pt";
        this.executableFullName = "PacketTracer5";
        this.genericOsName = "Linux";
        this.pathSeparator = ":";
        this.pathVariable = "PATH";
        this.saveSubDirectory = "SAVES";
        Utilities.logPrintln("\n==> void");
    }

    protected void initializeForWindows() {
        Utilities.logPrintln("()");
        this.defaultHome = "C:/Program Files/Packet Tracer 5.3.1";
        this.executableFullName = "PacketTracer5.exe";
        this.genericOsName = "Windows";
        this.pathSeparator = ";";
        this.pathVariable = "Path";
        this.saveSubDirectory = "saves";
        Utilities.logPrintln("\n==> void");
    }

    protected void completeInitializationBasedOnOs() {
        Utilities.logPrintln("completeInitializationBasedOnOs()");
        if (Utilities.isLinux()) {
            Utilities.logPrintln("??? Utilities.isLinux() = " + Utilities.isLinux());
            this.completeInitializationForLinux();
        } else if (Utilities.isWindows()) {
            Utilities.logPrintln("??? Utilities.isWindows() = " + Utilities.isWindows());
            this.completeInitializationForWindows();
        } else {
            throw new Error("Your operating system isn't supported by the Packet Tracer Skills Assessment Player.\n\tOperating System Information: " + System.getProperty("os.name", "none"));
        }
        Utilities.logPrintln("\n==> void");
    }

    protected void completeInitializationForLinux() {
        Utilities.logPrintln("completeInitializationForLinux()");
        this.executableString = this.getHomeDirectory() + "/packettracer";
        Utilities.logPrintln("... executableString = " + this.executableString);
        Utilities.logPrintln("\n==> void");
    }

    protected void completeInitializationForWindows() {
        Utilities.logPrintln("completeInitializationForWindows()");
        this.executableString = this.getBinDirectory() + "/" + this.executableFullName;
        Utilities.logPrintln("... executableString = " + this.executableString);
        Utilities.logPrintln("\n==> void");
    }

    protected File findHomeDirectory(String string, String string2) {
        Utilities.logPrintln("findHomeDirectory()");
        Utilities.logPrintln("\t\tenvironmentVariableNamesString = " + string);
        Utilities.logPrintln("\t\tspecificDirectoriesString = " + string2);
        try {
            JreInfo.soleInstance().osPath().setValue(System.getenv(this.pathVariable));
            JreInfo.soleInstance().osPt5Home().setValue(System.getenv("PT5HOME"));
            JreInfo.soleInstance().osPtDir().setValue(System.getenv("PTDIR"));
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        File file = this.searchEnvironmentVariables(string);
        Utilities.logPrintln("... ptHome = " + file);
        if (file != null) {
            Utilities.logPrintln("??? ptHome != null = " + (file != null));
            Utilities.logPrintln("\n==> " + file);
            return file;
        }
        file = this.searchSpecifiedDirectories(string2);
        Utilities.logPrintln("... ptHome = " + file);
        if (file != null) {
            Utilities.logPrintln("??? ptHome != null = " + (file != null));
            Utilities.logPrintln("\n==> " + file);
            return file;
        }
        file = this.searchPath();
        Utilities.logPrintln("... ptHome = " + file);
        if (file != null) {
            Utilities.logPrintln("??? ptHome != null = " + (file != null));
            Utilities.logPrintln("\n==> " + file);
            return file;
        }
        file = new File(this.defaultHome);
        Utilities.logPrintln("... ptHome = " + file);
        if (file != null && file.exists()) {
            Utilities.logPrintln("??? ptHome != null = " + (file != null));
            Utilities.logPrintln("\n==> " + file);
            return file;
        }
        throw new Error("Unable to find Packet Tracer installation directory.");
    }

    protected File searchEnvironmentVariables(String string) {
        Utilities.logPrintln("searchEnvironmentVariables()");
        Utilities.logPrintln("\t\tenvironmentVariableNamesString = " + string);
        if (string == null) {
            Utilities.logPrintln("??? environmentVariableNamesString == null = " + (string == null));
            Utilities.logPrintln("\n==> null");
            return null;
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = System.getenv(string2);
            Utilities.logPrintln("... environmentVariableName = " + string2);
            Utilities.logPrintln("... environmentVariableValue = " + string3);
            if (string3 == null) continue;
            Utilities.logPrintln("??? environmentVariableValue != null = " + (string3 != null));
            try {
                File file = new File(string3);
                Utilities.logPrintln("... ptHome = " + file);
                if (!file.exists()) continue;
                Utilities.logPrintln("??? ptHome.exists() = " + file.exists());
                Utilities.logPrintln("\n==> " + file);
                return file;
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        Utilities.logPrintln("\n==> null");
        return null;
    }

    protected File searchSpecifiedDirectories(String string) {
        Utilities.logPrintln("searchSpecifiedDirectories()");
        Utilities.logPrintln("\t\tspecificDirectoriesString = " + string);
        if (string == null) {
            Utilities.logPrintln("??? specificDirectoriesString == null = " + (string == null));
            Utilities.logPrintln("\n==> null");
            return null;
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Utilities.logPrintln("... directoryName = " + string2);
            try {
                File file = new File(string2);
                Utilities.logPrintln("... ptHome = " + file);
                if (!file.exists()) continue;
                Utilities.logPrintln("??? ptHome.exists() = " + file.exists());
                Utilities.logPrintln("\n==> " + file);
                return file;
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        Utilities.logPrintln("\n==> null");
        return null;
    }

    protected File searchPath() {
        Utilities.logPrintln("searchPath()");
        String string = this.getPath();
        Utilities.logPrintln("... path = " + string);
        String[] stringArray = string.split(this.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Utilities.logPrintln("... pathDir = " + string2);
            try {
                File file = new File(string2, this.executableFullName);
                Utilities.logPrintln("... executable = " + file);
                if (!file.exists()) continue;
                Utilities.logPrintln("??? executable.exists() = " + file.exists());
                Utilities.logPrintln("\n==> " + file.getParentFile().getParentFile());
                return file.getParentFile().getParentFile();
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        Utilities.logPrintln("\n==> null");
        return null;
    }

    protected String getPath() {
        Utilities.logPrintln("getPath()");
        Utilities.logPrintln("\n==> " + System.getenv(this.pathVariable));
        return System.getenv(this.pathVariable);
    }
}

