/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.io.File;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import skeletonapplet.AbstractFileInfo;
import skeletonapplet.ChunkInfo;
import skeletonapplet.ChunkInfoList;
import skeletonapplet.Utilities;

public class FileInfo
extends AbstractFileInfo {
    protected ChunkInfoList chunkInfoList = new ChunkInfoList();

    public FileInfo() {
    }

    public FileInfo(String string, int n, long l) {
        super(string, n, l);
    }

    public void addSpec(StringBuilder stringBuilder) {
        stringBuilder.append(this.length);
        stringBuilder.append("|");
        stringBuilder.append(this.checkSum);
        stringBuilder.append("|");
        stringBuilder.append(this.baseFileName);
        if (this.hasChunks()) {
            stringBuilder.append("|");
            this.chunkInfoList.addSpec(stringBuilder);
        }
    }

    public void addChunk(ChunkInfo chunkInfo) {
        this.chunkInfoList.add(chunkInfo);
    }

    public String getDownloadFileName() {
        return this.getBaseFileName() + ".chunk";
    }

    public ChunkInfoList getChunkInfoList() {
        return this.chunkInfoList;
    }

    public boolean hasChunks() {
        return !this.chunkInfoList.isEmpty();
    }

    public boolean validate(File file) {
        if (!this.baseFileName.equalsIgnoreCase(file.getName())) {
            return false;
        }
        if (!super.validate(file)) {
            return false;
        }
        if (this.baseFileName.endsWith(".jar")) {
            return this.validateJar(file);
        }
        if (this.baseFileName.endsWith(".zip")) {
            return this.validateZip(file);
        }
        return true;
    }

    public boolean validateJar(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            return true;
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            Utilities.println("\tValidating jar file ...FAIL");
            return false;
        }
    }

    public boolean validateZip(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            return true;
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            Utilities.println("\tValidating zip file ...FAIL");
            return false;
        }
    }

    public void parseSpec(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        List list = Utilities.simpleSplit(string.trim(), "|");
        this.length = Integer.parseInt(((String)list.get(0)).trim());
        this.checkSum = Long.parseLong(((String)list.get(1)).trim());
        this.baseFileName = ((String)list.get(2)).trim();
        if (list.size() >= 4) {
            this.chunkInfoList.parseSpec((String)list.get(3));
        }
    }
}

