/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.io.File;
import java.net.URL;
import javax.swing.ProgressMonitor;
import skeletonapplet.AtomicDownloader;
import skeletonapplet.ChunkDownloader;
import skeletonapplet.FileInfo;

public class Downloader {
    protected URL baseUrl;
    protected FileInfo fileInfo;
    protected byte[] downloadedData;
    protected File workDirectory;

    public Downloader(URL uRL, String string, File file) {
        this.baseUrl = uRL;
        this.fileInfo = new FileInfo();
        this.fileInfo.parseSpec(string);
        this.workDirectory = file;
    }

    public Downloader(URL uRL, FileInfo fileInfo, File file) {
        this.baseUrl = uRL;
        this.fileInfo = fileInfo;
        this.workDirectory = file;
    }

    public byte[] download(ProgressMonitor progressMonitor, int n) {
        return this.download(progressMonitor, n, 1);
    }

    public byte[] download(ProgressMonitor progressMonitor, int n, int n2) {
        if (this.fileInfo.hasChunks()) {
            ChunkDownloader chunkDownloader = new ChunkDownloader(this.baseUrl, this.fileInfo, this.workDirectory);
            this.downloadedData = chunkDownloader.download(progressMonitor, n, n2);
        } else {
            AtomicDownloader atomicDownloader = new AtomicDownloader(this.baseUrl, this.fileInfo);
            this.downloadedData = atomicDownloader.download(progressMonitor, n, n2);
        }
        return this.downloadedData;
    }
}

