/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.util.ArrayList;
import java.util.List;
import skeletonapplet.ChunkInfo;
import skeletonapplet.Utilities;

public class ChunkInfoList {
    protected List chunkInfos = new ArrayList();

    public ChunkInfoList() {
    }

    public ChunkInfoList(String string) {
        this.parseSpec(string);
    }

    public void add(ChunkInfo chunkInfo) {
        this.chunkInfos.add(chunkInfo);
    }

    public void addSpec(StringBuilder stringBuilder) {
        stringBuilder.append("[");
        for (int i = 0; i < this.chunkInfos.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            ChunkInfo chunkInfo = (ChunkInfo)this.chunkInfos.get(i);
            chunkInfo.addSpec(stringBuilder);
        }
        stringBuilder.append("]");
    }

    public List getChunkInfos() {
        return this.chunkInfos;
    }

    public String getSpec() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addSpec(stringBuilder);
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        return this.chunkInfos.isEmpty();
    }

    public String toString() {
        return this.getSpec();
    }

    public void parseSpec(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        String string2 = string.trim();
        if (string2.startsWith("[")) {
            string2 = string2.substring("[".length());
        }
        if (string2.endsWith("]")) {
            string2 = string2.substring(0, string2.length() - "]".length());
        }
        List list = Utilities.simpleSplit(string2.trim(), ",");
        for (int i = 0; i < list.size(); ++i) {
            ChunkInfo chunkInfo = new ChunkInfo();
            chunkInfo.parseSpec((String)list.get(i));
            this.chunkInfos.add(chunkInfo);
        }
    }
}

