/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.util.List;
import skeletonapplet.AbstractFileInfo;
import skeletonapplet.Utilities;

public class ChunkInfo
extends AbstractFileInfo {
    protected int chunkNumber;

    public ChunkInfo() {
    }

    public ChunkInfo(String string, int n, long l, int n2) {
        super(string, n, l);
        this.chunkNumber = n2;
    }

    public void addSpec(StringBuilder stringBuilder) {
        stringBuilder.append(this.getFormattedChunkNumber());
        stringBuilder.append("_");
        stringBuilder.append(this.length);
        stringBuilder.append("_");
        stringBuilder.append(this.checkSum);
        stringBuilder.append("_");
        stringBuilder.append(this.baseFileName);
    }

    public String getBaseFileName() {
        return this.getFormattedChunkNumber() + "-" + super.getBaseFileName();
    }

    public String getDownloadFileName() {
        return this.getBaseFileName() + ".chunk";
    }

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public String getFormattedChunkNumber() {
        return Utilities.padBefore(this.chunkNumber, "0", 4);
    }

    public void parseSpec(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        List list = Utilities.simpleSplit(string.trim(), "_");
        this.chunkNumber = Integer.parseInt(((String)list.get(0)).trim());
        this.length = Integer.parseInt(((String)list.get(1)).trim());
        this.checkSum = Long.parseLong(((String)list.get(2)).trim());
        this.baseFileName = ((String)list.get(3)).trim();
    }
}

