/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import skeletonapplet.AbstractDelegatorApplet;
import skeletonapplet.CheckEnvironmentAppletWorker;
import skeletonapplet.JreDatum;
import skeletonapplet.JreInfo;
import skeletonapplet.Utilities;

public class CheckEnvironmentDelegatorApplet
extends AbstractDelegatorApplet {
    protected JScrollPane scrollPane;
    protected JEditorPane editorPane;
    protected Map parameterMap;
    protected String errorDiagnosis;
    protected static final String DEFAULT_PARAMETER_XML_FILE_NAME = "/parameters-default.xml";
    protected static final String PARAMETER_XML_FILE_NAME = "/parameters.xml";

    public CheckEnvironmentDelegatorApplet() {
        this.initializeParameterMap();
        this.editorPane = new JEditorPane();
        this.editorPane.setContentType("text/html");
        this.scrollPane = new JScrollPane(this.editorPane);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.getContentPane().add(this.scrollPane);
        this.setVisible(false);
    }

    public void init() {
        super.init();
    }

    public void start() {
        super.start();
        this.editorPane.setVisible(true);
        this.editorPane.setContentType("text/html");
        this.editorPane.setText(this.getInitialHtml());
        this.scrollPane.setVisible(true);
        this.setVisible(true);
        this.errorDiagnosis = null;
        try {
            CheckEnvironmentAppletWorker checkEnvironmentAppletWorker = (CheckEnvironmentAppletWorker)this.worker;
            checkEnvironmentAppletWorker.runTests();
            String string = this.getReportHtml();
            this.editorPane.setText(string);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            this.editorPane.setText(this.getErrorHtml());
        }
    }

    public String getParameter(String string) {
        String string2 = (String)this.parameterMap.get(string);
        return string2 == null ? super.getParameter(string) : string2;
    }

    protected boolean initializationError(Throwable throwable) {
        return false;
    }

    protected boolean stopOnBrowserNameError() {
        return false;
    }

    protected boolean stopOnJarLoadingError(Throwable throwable) {
        return false;
    }

    protected boolean stopOnJreVersionError() {
        return false;
    }

    protected boolean stopOnMissingPatchFilesError(String string) {
        return false;
    }

    protected boolean stopOnNoJarFileError(String string) {
        return false;
    }

    protected boolean stopOnNoPtHomeError() {
        return false;
    }

    protected boolean stopOnNoRawFileError(String string) {
        return false;
    }

    protected boolean stopOnNoSecurityAccessError() {
        return true;
    }

    protected boolean stopOnNoWorkerError() {
        return false;
    }

    protected void initializeParameterMap() {
        this.parameterMap = new HashMap();
        this.loadHardCodedParameters(this.parameterMap);
        this.loadResourceBasedParameters(this.parameterMap, DEFAULT_PARAMETER_XML_FILE_NAME, false);
        this.loadResourceBasedParameters(this.parameterMap, PARAMETER_XML_FILE_NAME, true);
    }

    protected void loadHardCodedParameters(Map map) {
        map.put("allowedjavaversions", "1.5;1.6;1.7");
        map.put("allowedptversions", "5.2.0.007;5.2.0.008;5.2.0.009;5.2.0.01;5.2.1;5.3");
        map.put("disallowedptversions", "");
        map.put("linuxptdirectories", "/opt/pt");
        map.put("linuxptenvironmentvariables", "PT_LAUNCH_DIR,PTDIR,PT5HOME");
        map.put("minimumjavaversion", "1.5");
        map.put("minimumptversion", "5.2.0.0070");
        map.put("numberofdownloadtries", "5");
        map.put("ptaplayerauthentication", "ptaplayer.pta");
        map.put("ptaplayerfeatures", "autodownload,detailedlog,savebuffer");
        map.put("ptaplayerjarspec", "");
        map.put("ptaplayerlocation", "extensions/ptaplayer");
        map.put("ptaplayerpatchspecs", "");
        map.put("skeletonjarspec", "");
        map.put("windowsptdirectories", "C:\\Program Files\\Packet Tracer 5.3.1,C:\\Program Files (x86)\\Packet Tracer 5.3.1,C:\\Program Files\\Packet Tracer 5.3,C:\\Program Files (x86)\\Packet Tracer 5.3,C:\\Program Files\\Packet Tracer 5.2,C:\\Program Files (x86)\\Packet Tracer 5.2");
        map.put("windowsptenvironmentvariables", "PT_LAUNCH_DIR,PTDIR,PT5HOME");
        map.put("workerclass", "panther.pep.CheckEnvironmentWorker");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadResourceBasedParameters(Map map, String string, boolean bl) {
        InputStream inputStream = null;
        try {
            Object object;
            Object object2;
            if (bl) {
                object2 = this.getClass().getResource(string);
                object = ((URL)object2).openConnection();
                ((URLConnection)object).setUseCaches(false);
                ((URLConnection)object).connect();
                inputStream = ((URLConnection)object).getInputStream();
            } else {
                inputStream = this.getClass().getResourceAsStream(string);
            }
            if (inputStream != null) {
                object2 = DocumentBuilderFactory.newInstance();
                object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
                Document document = ((DocumentBuilder)object).parse(new InputSource(new InputStreamReader(inputStream)));
                Element element = document.getDocumentElement();
                List list = this.getElementChildren(element, "parameter");
                for (int i = 0; i < list.size(); ++i) {
                    Element element2 = (Element)list.get(i);
                    String string2 = element2.getAttribute("name");
                    String string3 = this.getText(this.getChild(element2, "value"));
                    if (string2 == null || string3 == null) continue;
                    map.put(string2, string3);
                }
            }
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            this.errorDiagnosis = "Unable to read environment parameters from Academy Connection servers.";
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                }
            }
        }
    }

    protected Element getChild(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            String string2;
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element) || !(string2 = (element = (Element)node2).getTagName()).equals(string)) continue;
            return element;
        }
        return null;
    }

    protected List getElementChildren(Node node, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            String string2;
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element) || !(string2 = (element = (Element)node2).getTagName()).equals(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    protected String getText(Element element) {
        if (element == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof CharacterData)) continue;
            CharacterData characterData = (CharacterData)node;
            stringBuilder.append(characterData.getData());
        }
        return stringBuilder.toString();
    }

    protected String getErrorHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<h1>Error</h1>\n");
        stringBuilder.append("<p>An error occurred, and the Environment Checker has no information on your system at this time.</p>\n");
        stringBuilder.append("<p>You can try to reload this page to start again, or visit this link at a later time.</p>\n");
        stringBuilder.append("<p>You can also make the attempt to take a Cisco Packet Tracer Skills Assessment.</p>\n");
        if (this.errorDiagnosis != null) {
            stringBuilder.append("<p>The following diagnosis may indicate the cause of your error:</p>\n");
            stringBuilder.append("<p>" + this.errorDiagnosis + "</p>\n");
        }
        return stringBuilder.toString();
    }

    protected String getInitialHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<h1>Gathering information ...</h1>\n");
        stringBuilder.append("<p>This process may take a few minutes.</p>\n");
        stringBuilder.append("<p>When it's finished, this text will be replaced by a report on your system's readiness for Cisco Packet Tracer Skills Assessments ...</p>\n");
        return stringBuilder.toString();
    }

    protected String getReportHtml() {
        JreInfo jreInfo = JreInfo.soleInstance();
        StringBuilder stringBuilder = new StringBuilder();
        this.addInformation(stringBuilder, jreInfo.browserName());
        this.addInformation(stringBuilder, jreInfo.jreVersion());
        this.addInformation(stringBuilder, jreInfo.missingPatchFiles());
        this.addInformation(stringBuilder, jreInfo.missingPtaJarFile());
        this.addInformation(stringBuilder, jreInfo.osName());
        this.addInformation(stringBuilder, jreInfo.ptDirectory());
        this.addInformation(stringBuilder, jreInfo.ptPortsAvailable());
        this.addInformation(stringBuilder, jreInfo.ptVersion());
        this.addInformation(stringBuilder, jreInfo.securityAccess());
        return stringBuilder.toString();
    }

    protected void addInformation(StringBuilder stringBuilder, JreDatum jreDatum) {
        String string = "0.1in";
        if (jreDatum.isError() && jreDatum.hasComment()) {
            string = "0";
        }
        stringBuilder.append("<p style=\"padding-top: 0; padding-bottom: 0; margin-top: 0; margin-bottom: " + string + "\">");
        this.addInformationHeading(stringBuilder, jreDatum.getPrettyName());
        this.addInformationValue(stringBuilder, jreDatum.isUnavailable() ? "Not Available" : jreDatum.getDynamicValue());
        stringBuilder.append("</p>\n");
        if (jreDatum.isError() && jreDatum.hasComment()) {
            this.addErrorMessage(stringBuilder, jreDatum.getComment());
        }
    }

    public void addInformationHeading(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<span style=\"color: BLUE; font-weight: bold; font-size: 20\">");
        stringBuilder.append(string);
        stringBuilder.append("</span>");
    }

    public void addInformationValue(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<span style=\"color: BLACK; font-size: 16\">&nbsp;&nbsp;--&nbsp;&nbsp;");
        stringBuilder.append(string);
        stringBuilder.append("</span>");
    }

    public void addErrorMessage(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<p style=\"color: RED; font-size: 16; padding-left: 0.5in; padding-top: 0; padding-bottom: 0; margin-top: 0; margin-bottom: 0.1in\"><span style=\"font-weight: bold; font-size: 20\">ERROR</span>&nbsp;&nbsp;--&nbsp;&nbsp;");
        stringBuilder.append(string);
        stringBuilder.append("</p>\n");
    }

    protected void dumpSystemProperties() {
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            String string2 = System.getProperty(string);
            System.out.println(string + " ==> <" + string2 + ">");
        }
    }
}

