/*
 * Decompiled with CFR 0.152.
 */
package pse.util.general;

import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class XmlWriter {
    protected PrintWriter printWriter;
    protected List<String> prefixStack;
    protected String additionalPrefix;
    protected List<String> elementStack;
    protected static DateFormat DEFAULT_DATE_FORMAT;

    public XmlWriter(Writer writer, String string, String string2) {
        this.printWriter = new PrintWriter(writer);
        this.prefixStack = new ArrayList<String>();
        this.prefixStack.add(string);
        this.elementStack = new ArrayList<String>();
        this.additionalPrefix = string2;
    }

    public void addAttribute(String string, boolean bl) {
        this.addAttribute(string, String.valueOf(bl));
    }

    public void addAttribute(String string, Object object) {
        this.addAttribute(string, String.valueOf(object));
    }

    public void addAttribute(String string, String string2) {
        this.printWriter.print(" " + string + "=\"" + XmlWriter.escape(string2) + "\"");
    }

    public void addCData(String string) {
        this.addPrefix();
        this.printWriter.println("<![CDATA[");
        String string2 = string == null ? "" : string.trim();
        this.printWriter.println(XmlWriter.escapeCData(string2));
        this.addPrefix();
        this.printWriter.println("]]>");
    }

    public void addCDataElement(String string, String string2) {
        this.openElement(string);
        this.addCData(string2);
        this.closeElement();
    }

    public void addDateAttribute(String string, Date date) {
        try {
            this.addAttribute(string, XmlWriter.getDefaultDateFormat().format(date));
        }
        catch (Exception exception) {
            throw new Error("Unable to format date attribute " + date, exception);
        }
    }

    public void addDocumentTypeDeclaration(String string, String string2) {
        this.printWriter.println("<!DOCTYPE " + string + " SYSTEM \"" + string2 + "\">");
    }

    public void addElement(String string) {
        this.addPrefix();
        this.printWriter.println("<" + string + " />");
    }

    public void addElement(String string, Object ... objectArray) {
        this.addPrefix();
        this.printWriter.print("<" + string);
        for (int i = 0; i < objectArray.length; i += 2) {
            this.addAttribute(String.valueOf(objectArray[i]), objectArray[i + 1]);
        }
        this.printWriter.println(" />");
    }

    public void addNullableAttribute(String string, Object object) {
        if (object != null) {
            this.addAttribute(string, object);
        }
    }

    public void addOmittableAttribute(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.addAttribute(string, bl);
        }
    }

    public void addOmittableAttribute(String string, int n, int n2) {
        if (n != n2) {
            this.addAttribute(string, n);
        }
    }

    public void addOmittableAttribute(String string, long l, long l2) {
        if (l != l2) {
            this.addAttribute(string, l);
        }
    }

    public void addOmittableAttribute(String string, String string2, String string3) {
        if (string2 != string3) {
            this.addAttribute(string, string2);
        }
    }

    public void addOmittableTextElement(String string, long l, long l2) {
        if (l != l2) {
            this.addTextElement(string, String.valueOf(l));
        }
    }

    public void addOmittableYesNoAttribute(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.addYesNoAttribute(string, bl);
        }
    }

    public void addOptionalCDataElement(String string, String string2) {
        if (string2 != null && string2.trim().length() > 0) {
            this.addCDataElement(string, string2);
        }
    }

    public void addOptionalDateAttribute(String string, Date date) {
        if (date != null) {
            this.addDateAttribute(string, date);
        }
    }

    public void addOptionalTextElement(String string, String string2) {
        if (string2 != null && string2.trim().length() > 0) {
            this.addTextElement(string, string2);
        }
    }

    public void addText(String string) {
        String string2 = string == null ? "" : string.trim();
        string2 = string2.replaceAll("\n", "\n" + this.getCurrentPrefix());
        this.addPrefix();
        this.printWriter.println(XmlWriter.escape(string2));
    }

    public void addTextInline(String string) {
        String string2 = string == null ? "" : string.trim();
        this.printWriter.print(XmlWriter.escape(string2));
    }

    public void addTextElement(String string, String string2) {
        this.openElement(string);
        this.addText(string2);
        this.closeElement();
    }

    public void addXmlDeclaration() {
        this.addXmlDeclaration("1.0", "utf-8");
    }

    public void addXmlDeclaration(String string, String string2) {
        this.printWriter.println("<?xml version=\"" + string + "\" encoding=\"" + string2 + "\"?>");
    }

    public void addYesNoAttribute(String string, boolean bl) {
        this.addAttribute(string, bl ? "yes" : "no");
    }

    public void closeElement() {
        this.decreasePrefix();
        String string = this.elementStack.remove(this.elementStack.size() - 1);
        this.addPrefix();
        this.printWriter.println("</" + string + ">");
    }

    public void openElement(String string) {
        this.startElement(string);
        this.stopElement();
    }

    public void openElement(String string, Object ... objectArray) {
        this.startElement(string);
        for (int i = 0; i < objectArray.length; i += 2) {
            this.addAttribute(String.valueOf(objectArray[i]), objectArray[i + 1]);
        }
        this.stopElement();
    }

    public void startElement(String string) {
        this.elementStack.add(string);
        this.addPrefix();
        this.printWriter.print("<" + string);
    }

    public void startElement(String string, Object ... objectArray) {
        this.elementStack.add(string);
        this.addPrefix();
        this.printWriter.print("<" + string);
        for (int i = 0; i < objectArray.length; i += 2) {
            this.addAttribute(String.valueOf(objectArray[i]), objectArray[i + 1]);
        }
    }

    public void stopElement() {
        this.printWriter.println(">");
        this.increasePrefix();
    }

    public void stopElementInline() {
        this.printWriter.print(">");
        this.increasePrefix();
    }

    public void stopAndCloseElement() {
        this.printWriter.println(" />");
        this.elementStack.remove(this.elementStack.size() - 1);
    }

    protected void increasePrefix() {
        this.prefixStack.add(this.getCurrentPrefix() + this.additionalPrefix);
    }

    protected String getCurrentPrefix() {
        return this.prefixStack.get(this.prefixStack.size() - 1);
    }

    protected void addPrefix() {
        this.printWriter.print(this.getCurrentPrefix());
    }

    protected void decreasePrefix() {
        this.prefixStack.remove(this.prefixStack.size() - 1);
    }

    public static String escapeCData(char c) {
        if (c <= '\u001f') {
            return XmlWriter.escapeLowCharacter(c);
        }
        return String.valueOf(c);
    }

    public static String escape(char c) {
        if (c <= '\u001f') {
            return XmlWriter.escapeLowCharacter(c);
        }
        if (c == '&') {
            return "&amp;";
        }
        if (c == '>') {
            return "&gt;";
        }
        if (c == '<') {
            return "&lt;";
        }
        if (c == '\"') {
            return "&quot;";
        }
        if (c == '\'') {
            return "&apos;";
        }
        return String.valueOf(c);
    }

    public static String escapeLowCharacter(char c) {
        if (c == '\n') {
            return "\n";
        }
        if (c == '\t') {
            return "\t";
        }
        if (c == '\u0000') {
            return "^0";
        }
        if (c == '\u0001') {
            return "^A";
        }
        if (c == '\u0002') {
            return "^B";
        }
        if (c == '\u0003') {
            return "^C";
        }
        if (c == '\u0004') {
            return "^D";
        }
        if (c == '\u0005') {
            return "^E";
        }
        if (c == '\u0006') {
            return "^F";
        }
        if (c == '\u0007') {
            return "^G";
        }
        if (c == '\b') {
            return "^H";
        }
        if (c == '\t') {
            return "^I";
        }
        if (c == '\n') {
            return "^J";
        }
        if (c == '\u000b') {
            return "^K";
        }
        if (c == '\f') {
            return "^L";
        }
        if (c == '\r') {
            return "";
        }
        if (c == '\u000e') {
            return "^N";
        }
        if (c == '\u000f') {
            return "^O";
        }
        if (c == '\u0010') {
            return "^P";
        }
        if (c == '\u0011') {
            return "^Q";
        }
        if (c == '\u0012') {
            return "^R";
        }
        if (c == '\u0013') {
            return "^S";
        }
        if (c == '\u0014') {
            return "^T";
        }
        if (c == '\u0015') {
            return "^U";
        }
        if (c == '\u0016') {
            return "^V";
        }
        if (c == '\u0017') {
            return "^W";
        }
        if (c == '\u0018') {
            return "^X";
        }
        if (c == '\u0019') {
            return "^Y";
        }
        if (c == '\u001a') {
            return "^X";
        }
        if (c == '\u001b') {
            return "^1";
        }
        if (c == '\u001c') {
            return "^2";
        }
        if (c == '\u001d') {
            return "^3";
        }
        if (c == '\u001e') {
            return "^4";
        }
        if (c == '\u001f') {
            return "^5";
        }
        return String.valueOf(c);
    }

    public static String escape(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(XmlWriter.escape(string.charAt(i)));
        }
        return stringBuilder.toString();
    }

    public static String escapeCData(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(XmlWriter.escapeCData(string.charAt(i)));
        }
        return stringBuilder.toString();
    }

    public static DateFormat getDefaultDateFormat() throws Exception {
        if (DEFAULT_DATE_FORMAT == null) {
            DEFAULT_DATE_FORMAT = XmlWriter.initializeDefaultDateFormat();
        }
        return DEFAULT_DATE_FORMAT;
    }

    protected static DateFormat initializeDefaultDateFormat() throws Exception {
        String string = "yyyy-MM-dd HH:mm:ss Z";
        return new SimpleDateFormat(string);
    }
}

