/*
 * Decompiled with CFR 0.152.
 */
package pse.util.general;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import pse.util.general.ApplicationError;
import pse.util.general.ErrorUtils;
import pse.util.general.XmlEntityResolver;
import pse.util.general.XmlParsingErrorHandler;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    public static String cdata(char c) {
        return "<![CDATA[" + XmlUtils.escapeCData(c) + "]]>";
    }

    public static String cdata(String string) {
        return "<![CDATA[" + XmlUtils.escapeCData(string) + "]]>";
    }

    public static String cdata(String string, String string2) {
        return string2 + "<![CDATA[\n" + XmlUtils.escapeCData(string) + "\n" + string2 + "]]>";
    }

    public static void clear(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        while (nodeList.getLength() > 0) {
            node.removeChild(nodeList.item(0));
        }
    }

    public static DocumentBuilder createDocumentBuilder() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new XmlEntityResolver());
        return documentBuilder;
    }

    public static String escape(char c) {
        if (c <= '\u001f') {
            return XmlUtils.escapeLowCharacter(c);
        }
        if (c == '&') {
            return "&amp;";
        }
        if (c == '>') {
            return "&gt;";
        }
        if (c == '<') {
            return "&lt;";
        }
        if (c == '\"') {
            return "&quot;";
        }
        if (c == '\'') {
            return "&apos;";
        }
        return String.valueOf(c);
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(XmlUtils.escape(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String escapeCData(char c) {
        if (c <= '\u001f') {
            return XmlUtils.escapeLowCharacter(c);
        }
        return String.valueOf(c);
    }

    public static String escapeCData(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(XmlUtils.escapeCData(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String escapeLowCharacter(char c) {
        if (c == '\n') {
            return "\n";
        }
        if (c == '\t') {
            return "\t";
        }
        if (c == '\u0000') {
            return "^0";
        }
        if (c == '\u0001') {
            return "^A";
        }
        if (c == '\u0002') {
            return "^B";
        }
        if (c == '\u0003') {
            return "^C";
        }
        if (c == '\u0004') {
            return "^D";
        }
        if (c == '\u0005') {
            return "^E";
        }
        if (c == '\u0006') {
            return "^F";
        }
        if (c == '\u0007') {
            return "^G";
        }
        if (c == '\b') {
            return "^H";
        }
        if (c == '\t') {
            return "^I";
        }
        if (c == '\n') {
            return "^J";
        }
        if (c == '\u000b') {
            return "^K";
        }
        if (c == '\f') {
            return "^L";
        }
        if (c == '\r') {
            return "";
        }
        if (c == '\u000e') {
            return "^N";
        }
        if (c == '\u000f') {
            return "^O";
        }
        if (c == '\u0010') {
            return "^P";
        }
        if (c == '\u0011') {
            return "^Q";
        }
        if (c == '\u0012') {
            return "^R";
        }
        if (c == '\u0013') {
            return "^S";
        }
        if (c == '\u0014') {
            return "^T";
        }
        if (c == '\u0015') {
            return "^U";
        }
        if (c == '\u0016') {
            return "^V";
        }
        if (c == '\u0017') {
            return "^W";
        }
        if (c == '\u0018') {
            return "^X";
        }
        if (c == '\u0019') {
            return "^Y";
        }
        if (c == '\u001a') {
            return "^X";
        }
        if (c == '\u001b') {
            return "^1";
        }
        if (c == '\u001c') {
            return "^2";
        }
        if (c == '\u001d') {
            return "^3";
        }
        if (c == '\u001e') {
            return "^4";
        }
        if (c == '\u001f') {
            return "^5";
        }
        return String.valueOf(c);
    }

    public static String escapeLowCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(XmlUtils.escapeLowCharacter(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String getAttribute(Node node, String string) {
        return XmlUtils.getAttributeValue(node, string);
    }

    public static String getAttribute(Node node, String string, String string2) {
        String string3 = XmlUtils.getAttribute(node, string);
        return string3 != null ? string3 : string2;
    }

    public static String getAttributeValue(Node node, String string) {
        Node node2;
        String string2 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return string2;
    }

    public static boolean getBooleanAttribute(Node node, String string, boolean bl) {
        String string2 = XmlUtils.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return bl;
        }
        if (string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes")) {
            return true;
        }
        if (string2.equalsIgnoreCase("f") || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("n") || string2.equalsIgnoreCase("no")) {
            return false;
        }
        return bl;
    }

    public static String getCData(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof CharacterData)) continue;
            stringBuffer.append(((CharacterData)node2).getData());
        }
        return stringBuffer.toString();
    }

    public static Node getChild(Node node, String string) {
        return node == null ? null : XmlUtils.getNamedChild(node, string);
    }

    public static Node getChild(Node node, String string, String string2, String string3) {
        List list = XmlUtils.getChildren(node, string);
        for (int i = 0; i < list.size(); ++i) {
            Node node2 = (Node)list.get(i);
            String string4 = XmlUtils.getAttribute(node2, string2);
            if (string4 == null || !string3.equalsIgnoreCase(string4)) continue;
            return node2;
        }
        return null;
    }

    public static Node getChildNamed(Node node, String string) {
        if (node == null) {
            return null;
        }
        List list = XmlUtils.getNamedChildren(node, string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (Node)list.get(0);
    }

    public static List getChildren(Node node, String string) {
        return node == null ? new ArrayList() : XmlUtils.getNamedChildren(node, string);
    }

    public static List getChildren(Node node) {
        if (node == null) {
            return new ArrayList();
        }
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    public static List getChildrensAttributes(Node node, String string, String string2) {
        List list = XmlUtils.getChildren(node, string);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Node node2 = (Node)list.get(i);
            arrayList.add(XmlUtils.getAttribute(node2, string2));
        }
        return arrayList;
    }

    public static String getChildText(Node node, String string) {
        return XmlUtils.getText(XmlUtils.getChild(node, string));
    }

    public static Date getDateAttribute(Node node, String string) {
        try {
            return XmlWriter.getDefaultDateFormat().parse(XmlUtils.getAttribute(node, string));
        }
        catch (Exception exception) {
            throw new Error("Unable to parse date attribute " + string, exception);
        }
    }

    public static String getDirectText(Node node) {
        if (node == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3 && nodeList.item(i).getNodeType() != 4) continue;
            stringBuffer.append(((CharacterData)nodeList.item(i)).getData());
        }
        return stringBuffer.toString();
    }

    public static String getDirectText(Node node, String string) {
        return XmlUtils.getDirectText(XmlUtils.getChild(node, string));
    }

    public static List getDirectText(List list) {
        if (list == null) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(XmlUtils.getDirectText((Node)list.get(i)));
        }
        return arrayList;
    }

    public static double getDoubleAttribute(Node node, String string, double d) {
        String string2 = XmlUtils.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return d;
        }
        double d2 = 0.0;
        try {
            d2 = Double.parseDouble(string2);
        }
        catch (Throwable throwable) {
            d2 = d;
        }
        return d2;
    }

    public static Element getElementChild(Node node, String string) {
        return (Element)XmlUtils.getChild(node, string);
    }

    public static List<Element> getElementChildren(Node node) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            arrayList.add((Element)nodeList.item(i));
        }
        return arrayList;
    }

    public static List<Element> getElementChildren(Node node, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !(element = (Element)nodeList.item(i)).getNodeName().equals(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    public static String getIMSText(Node node) {
        return XmlUtils.getDirectText(node, "LANGSTRING");
    }

    public static List getIMSText(List list) {
        if (list == null) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(XmlUtils.getIMSText((Node)list.get(i)));
        }
        return arrayList;
    }

    public static int getIntAttribute(Node node, String string, int n) {
        String string2 = XmlUtils.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            n2 = n;
        }
        return n2;
    }

    public static long getLongAttribute(Node node, String string, long l) {
        String string2 = XmlUtils.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return l;
        }
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string2);
        }
        catch (Throwable throwable) {
            l2 = l;
        }
        return l2;
    }

    public static Node getNamedChild(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static List getNamedChildren(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static Boolean getNullBooleanAttribute(Node node, String string) {
        String string2 = XmlUtils.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return null;
        }
        if (string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (string2.equalsIgnoreCase("f") || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("n") || string2.equalsIgnoreCase("no")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static List<Node> getNodeChildren(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    public static List<Node> getNodeChildren(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static String getNodeName(Node node) {
        return node == null ? null : node.getNodeName();
    }

    public static String getOptionalAttribute(Node node, String string, String string2) {
        String string3 = XmlUtils.getAttribute(node, string);
        if (string3 == null || string3.trim().length() == 0) {
            return string2;
        }
        return string3;
    }

    public static String getOptionalChildText(Node node, String string) {
        return XmlUtils.getText(XmlUtils.getChild(node, string));
    }

    public static long getOptionalChildTextAsLong(Node node, String string, long l) {
        String string2 = XmlUtils.getOptionalChildText(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return l;
        }
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string2);
        }
        catch (Throwable throwable) {
            l2 = l;
        }
        return l2;
    }

    public static Date getOptionalDateAttribute(Node node, String string) {
        String string2 = XmlUtils.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return null;
        }
        return XmlUtils.getDateAttribute(node, string);
    }

    public static boolean getOptionalYesNoAttribute(Node node, String string, boolean bl) {
        String string2 = XmlUtils.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return bl;
        }
        return string2.equalsIgnoreCase("yes");
    }

    public static String getText(Node node) {
        if (node == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3 && nodeList.item(i).getNodeType() != 4) continue;
            stringBuilder.append(((CharacterData)nodeList.item(i)).getData());
        }
        return stringBuilder.toString();
    }

    public static String getTransitiveText(Node node) {
        if (node == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() == 3 || nodeList.item(i).getNodeType() == 4) {
                stringBuilder.append(((CharacterData)nodeList.item(i)).getData());
                continue;
            }
            stringBuilder.append(XmlUtils.getTransitiveText(nodeList.item(i)));
        }
        return stringBuilder.toString();
    }

    public static String getTransitiveText(Node node, String string) {
        return XmlUtils.getTransitiveText(XmlUtils.getChild(node, string));
    }

    public static String getValue(Attributes attributes, String string) {
        return XmlUtils.getValue(attributes, string, null);
    }

    public static String getValue(Attributes attributes, String string, String string2) {
        String string3 = attributes.getValue(string);
        return string3 == null || string3.length() == 0 ? string2 : string3;
    }

    public static Node myParse(String string) {
        Node node = null;
        try {
            node = XmlUtils.parseToNode(string);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new ApplicationError.XMLSyntax(ErrorUtils.stackTrace(throwable));
        }
        return node;
    }

    public static void parse(String string, DefaultHandler defaultHandler) throws Exception {
        XmlUtils.parse(new InputSource(new File(string).toURL().toString()), defaultHandler);
    }

    public static void parse(InputSource inputSource, DefaultHandler defaultHandler) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputSource, defaultHandler);
    }

    public static Node safeParse(String string) {
        Node node = null;
        try {
            node = XmlUtils.myParse(string);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            ErrorUtils.swallow("XmlUtils.safeParse()", throwable);
        }
        return node;
    }

    public static Document parse(String string) throws Exception {
        return XmlUtils.parse(new FileInputStream(string));
    }

    public static Document parse(InputStream inputStream) throws Exception {
        return XmlUtils.parse(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(Reader reader) throws Exception {
        DocumentBuilder documentBuilder = XmlUtils.createDocumentBuilder();
        InputSource inputSource = new InputSource(reader);
        Document document = null;
        try {
            document = documentBuilder.parse(inputSource);
        }
        finally {
            reader.close();
        }
        return document;
    }

    public static Node parseToNode(String string) throws Exception {
        return XmlUtils.parseToNode(new StringReader(string));
    }

    public static Node parseToNode(Reader reader) throws Exception {
        return XmlUtils.parseToDocument(reader).getDocumentElement();
    }

    public static Document parseToDocument(String string) throws Exception {
        return XmlUtils.parseToDocument(new StringReader(string));
    }

    public static Document parseToDocument(Reader reader) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(reader));
        return document;
    }

    public static Document parseToDocument(String string, String string2) throws Exception {
        return XmlUtils.parseToDocument(string, new StringReader(string2));
    }

    public static Document parseToDocument(String string, Reader reader) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new XmlParsingErrorHandler(string));
        documentBuilder.setEntityResolver(new XmlEntityResolver());
        Document document = documentBuilder.parse(new InputSource(reader));
        return document;
    }

    public static Node parseToNode(String string, String string2) throws Exception {
        return XmlUtils.parseToNode(string, new StringReader(string2));
    }

    public static Node parseToNode(String string, Reader reader) throws Exception {
        return XmlUtils.parseToDocument(string, reader).getDocumentElement();
    }

    public static void writeXmlFile(Document document, String string) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(string);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }
}

