/*
 * Decompiled with CFR 0.152.
 */
package pse.util.general;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.CRC32;
import javax.swing.JOptionPane;
import pse.util.general.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static StringBuffer buffer = new StringBuffer();
    public static DateFormat STANDARD_DATE_FORMAT;
    public static final String[] BYTE_STRINGS;

    public static String bytes2String(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append((char)byArray[i]);
        }
        return stringBuilder.toString();
    }

    public static long calculateCheckSum(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return cRC32.getValue();
    }

    public static void check(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
    }

    public static void checkIgnore(Throwable throwable) {
        Utilities.check(throwable);
        Utilities.ignore(throwable);
    }

    public static void checkSwallow(Throwable throwable) {
        Utilities.check(throwable);
        Utilities.swallow(throwable);
    }

    public static boolean choose(String string, Object object) {
        return Utilities.choose(null, string, object);
    }

    public static boolean choose(Component component, String string, Object object) {
        int n = JOptionPane.showConfirmDialog(component, object, string, 0, 3);
        return n == 0;
    }

    public static String constructPath(String string, String string2) {
        String string3 = string;
        String string4 = System.getProperty("file.separator");
        if (!string3.endsWith(string4)) {
            string3 = string3.concat(string4);
        }
        string3 = string3.concat(string2);
        return string3;
    }

    public static void copy(File file, File file2) throws Exception {
        file2.getParentFile().mkdirs();
        Utilities.copy(new FileInputStream(file), new FileOutputStream(file2));
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws Exception {
        Utilities.copy(inputStream, outputStream, true);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, boolean bl) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        int n = 0;
        byte[] byArray = new byte[4096];
        while ((n = bufferedInputStream.read(byArray, 0, 4096)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.flush();
        if (bl) {
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
    }

    public static void copyDirectory(File file, File file2) throws Exception {
        file2.mkdirs();
        for (File file3 : file.listFiles()) {
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                if (file3.equals(file)) continue;
                Utilities.copyDirectory(file3, file4);
                continue;
            }
            Utilities.copy(file3, file4);
        }
    }

    public static String currentDateString() {
        return Utilities.dateString(Calendar.getInstance());
    }

    public static Date dateFromString(String string) throws ParseException {
        return Utilities.getStandardDateFormat().parse(string);
    }

    public static String dateString(Calendar calendar) {
        return Utilities.dateString(calendar.getTime());
    }

    public static String dateString(Date date) {
        return Utilities.getStandardDateFormat().format(date);
    }

    public static byte[] decodeHex(String string) {
        if (string == null) {
            throw new Error("Invalid null hex string");
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            throw new Error("Invalid empty hex string: <" + string + ">");
        }
        if (string2.length() % 2 == 1) {
            throw new Error("Invalid odd-length hex string: <" + string + ">");
        }
        int n = string2.length();
        int n2 = n / 2;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byte by;
            int n3 = i * 2;
            String string3 = string2.substring(n3, n3 + 2);
            int n4 = Integer.parseInt(string3, 16);
            if (n4 >= 128) {
                n4 -= 256;
            }
            byArray[i] = by = (byte)n4;
        }
        return byArray;
    }

    public static String encodeHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Utilities.encodeHex(stringBuilder, byArray);
        return stringBuilder.toString();
    }

    public static void encodeHex(StringBuilder stringBuilder, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            if (n < 0) {
                n += 256;
            }
            int n2 = (n &= 0xFF) % 16;
            int n3 = n / 16;
            stringBuilder.append(BYTE_STRINGS[n3]);
            stringBuilder.append(BYTE_STRINGS[n2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileWrite(InputStream inputStream, String string) throws Exception {
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            File file = new File(string);
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[16384];
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            fileOutputStream = null;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static String formatMillisecondsAsTimeString(long l) {
        return Utilities.formatSecondsAsTimeString((int)l / 1000);
    }

    public static String formatSecondsAsTimeString(int n) {
        int n2 = n / 3600;
        int n3 = n % 3600 / 60;
        int n4 = n % 60;
        return (n2 < 10 ? "0" : "") + n2 + ":" + (n3 < 10 ? "0" : "") + n3 + ":" + (n4 < 10 ? "0" : "") + n4;
    }

    public static void guaranteedSleep(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l2 > System.currentTimeMillis()) {
            Utilities.safeSleep(l2 - System.currentTimeMillis());
        }
    }

    public static long guaranteedSleepNoTricks(long l) {
        long l2;
        long l3;
        for (l2 = 0L; l2 < l; l2 += l3) {
            long l4 = l - l2;
            long l5 = System.currentTimeMillis();
            Utilities.safeSleep(l4);
            long l6 = System.currentTimeMillis();
            l3 = l6 - l5;
            if (l3 <= 0L) {
                l3 = l4;
                continue;
            }
            if (l3 < 8L * l4) continue;
            l3 = l4;
        }
        return l2;
    }

    public static DateFormat getStandardDateFormat() {
        if (STANDARD_DATE_FORMAT != null) {
            return STANDARD_DATE_FORMAT;
        }
        try {
            STANDARD_DATE_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss 'GMT+00:00' yyyy");
            TimeZone timeZone = TimeZone.getTimeZone("GMT+00:00");
            STANDARD_DATE_FORMAT.setTimeZone(timeZone);
            return STANDARD_DATE_FORMAT;
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            STANDARD_DATE_FORMAT = new SimpleDateFormat();
            return STANDARD_DATE_FORMAT;
        }
    }

    public static void ignore(Throwable throwable) {
        Utilities.ignore(throwable.getMessage(), throwable);
    }

    public static void ignore(String string, Throwable throwable) {
        Utilities.println(Constants.fillIn("Warning: \nIgnored Exception: FOO1\nFOO2\n", string, Utilities.stackTrace(throwable)));
    }

    public static void print(String string) {
        System.out.print(string);
        buffer.append(string);
    }

    public static void print(Throwable throwable) {
        Utilities.println(throwable.getMessage());
        Utilities.println(Utilities.stackTrace(throwable));
    }

    public static void println(String string) {
        System.out.println(string);
        buffer.append(string);
        buffer.append('\n');
    }

    public static String read(InputStream inputStream) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[16384];
        int n = 0;
        while (n >= 0) {
            n = inputStreamReader.read(cArray, 0, 16384);
            if (n <= 0) continue;
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public static String readAsHexString(InputStream inputStream) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[16384];
        int n = 1;
        while (n >= 0) {
            n = inputStream.read(byArray, 0, 16384);
            for (int i = 0; i < n; ++i) {
                String string = Integer.toHexString(byArray[0]);
                if (string.length() == 1) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public static byte[] readBytes(InputStream inputStream) throws Exception {
        int n = 163840;
        int n2 = 0;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[16384];
        int n3 = 0;
        while (n3 >= 0) {
            int n4;
            n3 = inputStream.read(byArray2, 0, 16384);
            if (n3 <= 0) continue;
            if (n2 + n3 > n) {
                n4 = n * 2;
                byte[] byArray3 = new byte[n4];
                for (int i = 0; i < n2; ++i) {
                    byArray3[i] = byArray[i];
                }
                byArray = byArray3;
                n = n4;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                byArray[n2 + n4] = byArray2[n4];
            }
            n2 += n3;
        }
        byte[] byArray4 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray4[i] = byArray[i];
        }
        return byArray4;
    }

    public static void reportTime(String string, long l, long l2) {
        try {
            Utilities.println("Timing Information:\n\t" + (l2 - l) + " ms for " + string);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {
                Utilities.checkIgnore(throwable);
            }
        }
    }

    public static void safeSleep(long l) {
        try {
            Utilities.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String safeUrlEncode(String string) {
        try {
            return Utilities.urlEncode(string);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            return string;
        }
    }

    public static List<String> simpleSplit(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            arrayList.add(string.substring(n, n2));
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        arrayList.add(string.substring(n));
        return arrayList;
    }

    public static void sleep(long l) throws InterruptedException {
        if (l > 0L) {
            Thread.sleep(l);
        }
    }

    public static <T extends Comparable> List<T> sort(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static void swallow(Throwable throwable) {
        Utilities.swallow(throwable.getMessage(), throwable);
    }

    public static void swallow(String string, Throwable throwable) {
        Utilities.println(Constants.fillIn("Warning: \nSwallowed Exception: FOO1\nFOO2\n", string, Utilities.stackTrace(throwable)));
    }

    public static String stackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(16384);
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return ((Object)stringWriter).toString();
    }

    public static String urlEncode(String string) throws Exception {
        return URLEncoder.encode(string, "utf-8");
    }

    public static void warn(String string, String string2) {
        Utilities.warn(null, string, string2);
    }

    public static void warn(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 2);
    }

    static {
        BYTE_STRINGS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    }
}

