/*
 * Decompiled with CFR 0.152.
 */
package pse.util.general;

import pse.util.general.ErrorUtils;

public abstract class ApplicationError
extends Error {
    public ApplicationError() {
    }

    public ApplicationError(String string) {
        super(string);
    }

    public ApplicationError(String string, Throwable throwable) {
        super(string, throwable);
    }

    public ApplicationError(Throwable throwable) {
        super(throwable);
    }

    public abstract String canonicalString();

    public String htmlString() {
        return this.canonicalString();
    }

    public String xmlString() {
        return this.canonicalString();
    }

    public String toString() {
        return this.canonicalString();
    }

    public static class XMLSyntax
    extends ApplicationError {
        public XMLSyntax() {
        }

        public XMLSyntax(String string) {
            super(string);
        }

        public XMLSyntax(String string, Throwable throwable) {
            super(string, throwable);
        }

        public XMLSyntax(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "Input XML failed to parse because of the following syntax error:\n\t" + this.getMessage() + "\n";
        }
    }

    public static class XMLSemantics
    extends ApplicationError {
        public XMLSemantics() {
        }

        public XMLSemantics(String string) {
            super(string);
        }

        public XMLSemantics(String string, Throwable throwable) {
            super(string, throwable);
        }

        public XMLSemantics(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "Input XML is invalid because of the following semantic error:\n\t" + this.getMessage() + "\n";
        }
    }

    public static class UserPermission
    extends ApplicationError {
        public UserPermission() {
        }

        public UserPermission(String string) {
            super(string);
        }

        public UserPermission(String string, Throwable throwable) {
            super(string, throwable);
        }

        public UserPermission(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The user was denied permission for the following reason:\n\t" + this.getMessage() + "\n";
        }
    }

    public static class UserInput
    extends ApplicationError {
        public UserInput() {
        }

        public UserInput(String string) {
            super(string);
        }

        public UserInput(String string, Throwable throwable) {
            super(string, throwable);
        }

        public UserInput(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "User input is invalid because of the following error:\n\t" + this.getMessage() + "\n";
        }
    }

    public static class Unimplemented
    extends ApplicationError {
        public Unimplemented() {
        }

        public Unimplemented(String string) {
            super(string);
        }

        public Unimplemented(String string, Throwable throwable) {
            super(string, throwable);
        }

        public Unimplemented(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "An internal logical error occurred while processing the request because of an attempted use of unimplemented functionality.\nYou may re-attempt the request, but it's probable that it will not succeed until the error is fixed and the application restarted.\n\nIf you report this problem to application support, include the following internal error information:\n" + ErrorUtils.stackTrace(this) + "\n";
        }
    }

    public static class Unhandled
    extends ApplicationError {
        public Unhandled() {
        }

        public Unhandled(String string) {
            super(string);
        }

        public Unhandled(String string, Throwable throwable) {
            super(string, throwable);
        }

        public Unhandled(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "An internal logical error occurred while processing the request.\nYou may re-attempt the request, but it's probable that it will not succeed until the error is fixed and the application restarted.\n\nIf you report this problem to application support, include the following internal error information:\n" + this.getMessage() + "\n";
        }
    }

    public static class SystemInitialization
    extends ApplicationError {
        public SystemInitialization() {
        }

        public SystemInitialization(String string) {
            super(string);
        }

        public SystemInitialization(String string, Throwable throwable) {
            super(string, throwable);
        }

        public SystemInitialization(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "An internal logical error occurred while attempting to initialize the application.\nThe application will not function until this error is resolved and the application is restared.\n\nInternal error information:\n" + this.getMessage() + "\n";
        }
    }

    public static class System
    extends ApplicationError {
        public System() {
        }

        public System(String string) {
            super(string);
        }

        public System(String string, Throwable throwable) {
            super(string, throwable);
        }

        public System(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "An internal logical error occurred while processing the request.\nYou may re-attempt the request, but it's probable that it will not succeed until the error is fixed and the application restarted.\n\nIf you report this problem to application support, include the following internal error information:\n" + this.getMessage() + "\n";
        }
    }

    public static class SubmissionError
    extends ApplicationError {
        public SubmissionError() {
        }

        public SubmissionError(String string) {
            super(string);
        }

        public SubmissionError(String string, Throwable throwable) {
            super(string, throwable);
        }

        public SubmissionError(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The system encounted an error while submitting your assessment results.";
        }
    }

    public static class SaveXmlPosting
    extends ApplicationError {
        public SaveXmlPosting() {
        }

        public SaveXmlPosting(String string) {
            super(string);
        }

        public SaveXmlPosting(String string, Throwable throwable) {
            super(string, throwable);
        }

        public SaveXmlPosting(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The system encountered an error while saving information about your assessment.";
        }
    }

    public static class SaveXmlCreation
    extends ApplicationError {
        public SaveXmlCreation() {
        }

        public SaveXmlCreation(String string) {
            super(string);
        }

        public SaveXmlCreation(String string, Throwable throwable) {
            super(string, throwable);
        }

        public SaveXmlCreation(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The system encountered an error while creating information about your assessment session.";
        }
    }

    public static class SaveGeneration
    extends ApplicationError {
        public SaveGeneration() {
        }

        public SaveGeneration(String string) {
            super(string);
        }

        public SaveGeneration(String string, Throwable throwable) {
            super(string, throwable);
        }

        public SaveGeneration(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The system's save generation is out of synch with the server.";
        }
    }

    public static class PutSessionXml
    extends ApplicationError {
        public PutSessionXml() {
        }

        public PutSessionXml(String string) {
            super(string);
        }

        public PutSessionXml(String string, Throwable throwable) {
            super(string, throwable);
        }

        public PutSessionXml(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The system encountered an error while saving information about your assessment session.";
        }
    }

    public static class PkaVersion
    extends ApplicationError {
        public PkaVersion() {
        }

        public PkaVersion(String string) {
            super(string);
        }

        public PkaVersion(String string, Throwable throwable) {
            super(string, throwable);
        }

        public PkaVersion(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The system is unable to load the PKA contents because its version is incompatible with Packet Tracer's version.";
        }
    }

    public static class ParameterProcessing
    extends ApplicationError {
        public ParameterProcessing() {
        }

        public ParameterProcessing(String string) {
            super(string);
        }

        public ParameterProcessing(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ParameterProcessing(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The system encountered an error processing initialization information.";
        }
    }

    public static class PacketTracerVersionReducedError
    extends ApplicationError {
        protected String currentPtVersion;
        protected String requiredPtVersion;

        public PacketTracerVersionReducedError(String string, String string2) {
            this.currentPtVersion = string;
            this.requiredPtVersion = string2;
        }

        public PacketTracerVersionReducedError(String string, String string2, String string3) {
            super(string);
            this.currentPtVersion = string2;
            this.requiredPtVersion = string3;
        }

        public PacketTracerVersionReducedError(String string, Throwable throwable, String string2, String string3) {
            super(string, throwable);
            this.currentPtVersion = string2;
            this.requiredPtVersion = string3;
        }

        public PacketTracerVersionReducedError(Throwable throwable, String string, String string2) {
            super(throwable);
            this.currentPtVersion = string;
            this.requiredPtVersion = string2;
        }

        public String canonicalString() {
            return "Your computer has a lower version of Cisco Packet Tracer configured for the PTSA Player than was used to save your Packet Tracer Skills Assessment previously.";
        }

        public String getCurrentPtVersion() {
            return this.currentPtVersion;
        }

        public String getRequiredPtVersion() {
            return this.requiredPtVersion;
        }
    }

    public static class PacketTracerVersionProblem
    extends ApplicationError {
        public PacketTracerVersionProblem() {
        }

        public PacketTracerVersionProblem(String string) {
            super(string);
        }

        public PacketTracerVersionProblem(String string, Throwable throwable) {
            super(string, throwable);
        }

        public PacketTracerVersionProblem(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "There is a problem with the version of Packet Tracer designated for use.";
        }
    }

    public static class PacketTracerLaunch
    extends ApplicationError {
        public PacketTracerLaunch() {
        }

        public PacketTracerLaunch(String string) {
            super(string);
        }

        public PacketTracerLaunch(String string, Throwable throwable) {
            super(string, throwable);
        }

        public PacketTracerLaunch(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The system was unable to launch Packet Tracer.";
        }
    }

    public static class PacketTracerConnectTimeOut
    extends ApplicationError {
        public PacketTracerConnectTimeOut() {
        }

        public PacketTracerConnectTimeOut(String string) {
            super(string);
        }

        public PacketTracerConnectTimeOut(String string, Throwable throwable) {
            super(string, throwable);
        }

        public PacketTracerConnectTimeOut(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The system wasn't able to set up communication with Packet Tracer in a timely manner.";
        }
    }

    public static class NoPka
    extends ApplicationError {
        public NoPka() {
        }

        public NoPka(String string) {
            super(string);
        }

        public NoPka(String string, Throwable throwable) {
            super(string, throwable);
        }

        public NoPka(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The system can't find the information needed to initialize the Cisco Packet Tracer Skills Assessment.";
        }
    }

    public static class NoIpcPort
    extends ApplicationError {
        public NoIpcPort() {
        }

        public NoIpcPort(String string) {
            super(string);
        }

        public NoIpcPort(String string, Throwable throwable) {
            super(string, throwable);
        }

        public NoIpcPort(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The system can't find an available port for communicating with Packet Tracer.";
        }
    }

    public static class IpcError
    extends ApplicationError {
        public IpcError() {
        }

        public IpcError(String string) {
            super(string);
        }

        public IpcError(String string, Throwable throwable) {
            super(string, throwable);
        }

        public IpcError(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "An error occurred while the system was communicating with Packet Tracer.";
        }
    }

    public static class InvalidPassword
    extends ApplicationError {
        public InvalidPassword() {
        }

        public InvalidPassword(String string) {
            super(string);
        }

        public InvalidPassword(String string, Throwable throwable) {
            super(string, throwable);
        }

        public InvalidPassword(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "The provided username/password are not valid.\n";
        }
    }

    public static class HigherMinimumPtVersionError
    extends ApplicationError {
        protected String currentPtVersion;
        protected String requiredPtVersion;

        public HigherMinimumPtVersionError(String string, String string2) {
            this.currentPtVersion = string;
            this.requiredPtVersion = string2;
        }

        public HigherMinimumPtVersionError(String string, String string2, String string3) {
            super(string);
            this.currentPtVersion = string2;
            this.requiredPtVersion = string3;
        }

        public HigherMinimumPtVersionError(String string, Throwable throwable, String string2, String string3) {
            super(string, throwable);
            this.currentPtVersion = string2;
            this.requiredPtVersion = string3;
        }

        public HigherMinimumPtVersionError(Throwable throwable, String string, String string2) {
            super(throwable);
            this.currentPtVersion = string;
            this.requiredPtVersion = string2;
        }

        public String canonicalString() {
            return "This particular Cisco Packet Tracer Skills Assessment requires a more recent version of Packet Tracer than what is configured for the PTSA Player.";
        }

        public String getCurrentPtVersion() {
            return this.currentPtVersion;
        }

        public String getRequiredPtVersion() {
            return this.requiredPtVersion;
        }
    }

    public static class GetSessionXml
    extends ApplicationError {
        public GetSessionXml() {
        }

        public GetSessionXml(String string) {
            super(string);
        }

        public GetSessionXml(String string, Throwable throwable) {
            super(string, throwable);
        }

        public GetSessionXml(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "An error occurred while the system tried to retrieve information about your current assessment session.";
        }
    }

    public static class FileSystem
    extends ApplicationError {
        public FileSystem() {
        }

        public FileSystem(String string) {
            super(string);
        }

        public FileSystem(String string, Throwable throwable) {
            super(string, throwable);
        }

        public FileSystem(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "An error occurred while attempting to access the file system.\nYou may re-attempt the request, but it's probable that it will not succeed until the error is fixed.\n\nIf you report this problem to application support, include the following internal error information:\n" + this.getMessage() + "\n";
        }
    }

    public static class Database
    extends ApplicationError {
        public Database() {
        }

        public Database(String string) {
            super(string);
        }

        public Database(String string, Throwable throwable) {
            super(string, throwable);
        }

        public Database(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "An error occurred while attempting to access the database.\nYou may re-attempt the request, but it's probable that it will not succeed until the error is fixed.\n\nIf you report this problem to application support, include the following internal error information:\n" + this.getMessage() + "\n";
        }
    }

    public static class ComponentInitialization
    extends ApplicationError {
        protected String component;

        public ComponentInitialization() {
        }

        public ComponentInitialization(String string, String string2) {
            super(string);
            this.component = string2;
        }

        public ComponentInitialization(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ComponentInitialization(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "An internal logical error occurred while attempting to initialize the application component " + this.component + ".\nThe application will not function until this error is resolved and the application is restared.\n\nInternal error information:\n" + this.getMessage() + "\n";
        }
    }

    public static class Authentication
    extends ApplicationError {
        public Authentication() {
        }

        public Authentication(String string) {
            super(string);
        }

        public Authentication(String string, Throwable throwable) {
            super(string, throwable);
        }

        public Authentication(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "An internal logical error occurred while attempting to authenticate the request.\nYou may re-attempt the request, but it's probable that it will not succeed until the error is fixed and the application restarted.\n\nIf you report this problem to application support, include the following internal error information:\n" + this.getMessage() + "\n";
        }
    }

    public static class AssessmentComplete
    extends ApplicationError {
        public AssessmentComplete() {
        }

        public AssessmentComplete(String string) {
            super(string);
        }

        public AssessmentComplete(String string, Throwable throwable) {
            super(string, throwable);
        }

        public AssessmentComplete(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "Your assessment was completed, perhaps on a different computer or through a different browser window or tab.";
        }
    }

    public static class AppletOvertaken
    extends ApplicationError {
        public AppletOvertaken() {
        }

        public AppletOvertaken(String string) {
            super(string);
        }

        public AppletOvertaken(String string, Throwable throwable) {
            super(string, throwable);
        }

        public AppletOvertaken(Throwable throwable) {
            super(throwable);
        }

        public String canonicalString() {
            return "A new assessment applet was started some time after this one.  Since only one is allowed at a time, this applet is now inactive.";
        }
    }
}

