/*
 * Decompiled with CFR 0.152.
 */
package pse.result;

import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.Node;
import pse.result.ResultObject;
import pse.util.general.Utilities;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public abstract class TimeStampedObject
extends ResultObject {
    protected Calendar clientTime;
    protected Calendar serverTime;
    protected String clientTimeString = "@@@CLIENT_TIME@@@";
    protected String serverTimeString = "@@@SERVER_TIME@@@";

    public boolean hasAttributes() {
        return true;
    }

    public Calendar getClientTime() {
        return this.clientTime;
    }

    public String getClientTimeString() {
        return this.clientTimeString;
    }

    public void fillInClientTime(Calendar calendar) {
        if (this.clientTimeString.equals("@@@CLIENT_TIME@@@")) {
            this.setClientTime(calendar);
        }
    }

    public void setClientTime() {
        this.setClientTime(Calendar.getInstance());
    }

    public void setClientTime(Calendar calendar) {
        this.clientTime = calendar;
        this.clientTimeString = Utilities.dateString(calendar);
    }

    public void setClientTimeForFillIn() {
        this.clientTimeString = "@@@CLIENT_TIME@@@";
        this.clientTime = null;
    }

    public void setClientTimeString(String string) {
        this.clientTimeString = string;
        try {
            Date date = Utilities.dateFromString(string);
            this.clientTime = Calendar.getInstance();
            this.clientTime.setTime(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Calendar getServerTime() {
        return this.serverTime;
    }

    public String getServerTimeString() {
        return this.serverTimeString;
    }

    public void fillInServerTime(Calendar calendar) {
        if (this.serverTimeString.equals("@@@SERVER_TIME@@@")) {
            this.setServerTime(calendar);
        }
    }

    public void setServerTime() {
        this.setServerTime(Calendar.getInstance());
    }

    public void setServerTime(Calendar calendar) {
        this.serverTime = calendar;
        this.serverTimeString = Utilities.dateString(calendar);
    }

    public void setServerTimeForFillIn() {
        this.serverTimeString = "@@@SERVER_TIME@@@";
        this.serverTime = null;
    }

    public void setServerTimeString(String string) {
        this.serverTimeString = string;
        try {
            Date date = Utilities.dateFromString(string);
            this.serverTime = Calendar.getInstance();
            this.serverTime.setTime(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addNullableAttribute("client-time", this.clientTimeString);
        xmlWriter.addNullableAttribute("server-time", this.serverTimeString);
    }

    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.setClientTimeString(XmlUtils.getOptionalAttribute(node, "client-time", "@@@CLIENT_TIME@@@"));
        this.setServerTimeString(XmlUtils.getOptionalAttribute(node, "server-time", "@@@SERVER_TIME@@@"));
    }
}

