/*
 * Decompiled with CFR 0.152.
 */
package pse.result;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pse.result.AutoSave;
import pse.result.IosLog;
import pse.result.ResultObject;
import pse.result.SessionEnd;
import pse.result.SessionEvent;
import pse.result.SessionStart;
import pse.result.SittingEnd;
import pse.result.SittingStart;
import pse.result.WorkProductSummary;
import pse.result.XpassSession;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
extends ResultObject {
    protected List<SessionEvent> events = new ArrayList<SessionEvent>();
    protected SittingStart sittingStart;

    @Override
    public String getElementName() {
        return "session";
    }

    public String getMostRecentPtVersion() {
        return this.sittingStart == null ? null : this.sittingStart.getPtVersion();
    }

    public SittingStart getSittingStart() {
        return this.sittingStart;
    }

    public XpassSession getXpassSession() {
        return this.sittingStart == null ? null : this.sittingStart.getXpassSession();
    }

    public long getTimeUsed() {
        SessionEvent sessionEvent = this.getLastEvent();
        return sessionEvent == null ? -1L : sessionEvent.getTimeUsed();
    }

    public long getTimeAllowed() {
        SessionEvent sessionEvent = this.getLastEvent();
        return sessionEvent == null ? -1L : sessionEvent.getTimeAllowed();
    }

    public String getEndTimeString() {
        SessionEnd sessionEnd = this.getSessionEnd();
        return sessionEnd == null ? "N/A" : sessionEnd.getClientTimeString();
    }

    public String getStartTimeString() {
        SessionStart sessionStart = this.getSessionStart();
        return sessionStart == null ? "N/A" : sessionStart.getClientTimeString();
    }

    public SessionEnd getSessionEnd() {
        if (this.events.isEmpty()) {
            return null;
        }
        SessionEvent sessionEvent = this.events.get(this.events.size() - 1);
        return sessionEvent instanceof SessionEnd ? (SessionEnd)sessionEvent : null;
    }

    public SessionStart getSessionStart() {
        return this.events.isEmpty() ? null : (SessionStart)this.events.get(0);
    }

    public SessionEvent getLastEvent() {
        return this.events.isEmpty() ? null : this.events.get(this.events.size() - 1);
    }

    public SittingStart getLatestSittingStart() {
        for (int i = this.events.size() - 1; i >= 0; --i) {
            SessionEvent sessionEvent = this.events.get(i);
            if (!(sessionEvent instanceof SittingStart)) continue;
            return (SittingStart)sessionEvent;
        }
        return null;
    }

    public boolean endsWithSittingEnd() {
        SessionEvent sessionEvent = this.getLastEvent();
        return sessionEvent != null && sessionEvent instanceof SittingEnd;
    }

    public void fillInClientTime(Calendar calendar) {
        for (SessionEvent sessionEvent : this.events) {
            sessionEvent.fillInClientTime(calendar);
        }
    }

    public void fillInServerTime(Calendar calendar) {
        for (SessionEvent sessionEvent : this.events) {
            sessionEvent.fillInServerTime(calendar);
        }
    }

    public long getTimeRemaining() {
        for (int i = this.events.size() - 1; i >= 0; --i) {
            SessionEvent sessionEvent = this.events.get(i);
            if (!sessionEvent.hasTimeRemaining()) continue;
            return sessionEvent.getTimeRemaining();
        }
        return -1L;
    }

    public void noteAutoSave(byte[] byArray, IosLog iosLog, Calendar calendar) {
        long l = this.sittingStart.getTimeAllowed();
        long l2 = this.sittingStart.getCurrentTimeRemaining();
        long l3 = l - l2;
        AutoSave autoSave = new AutoSave();
        autoSave.setClientTime(calendar);
        autoSave.setServerTimeForFillIn();
        autoSave.setTimeRemaining(l2);
        autoSave.setTimeUsed(l3);
        WorkProductSummary workProductSummary = autoSave.getOrCreateWorkProductSummary();
        workProductSummary.setPkaContents(byArray);
        workProductSummary.setCommandSize(iosLog.getCommandSize());
        this.addEvent(autoSave);
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.events.size() > 0;
    }

    public List<SessionEvent> getEvents() {
        return this.events;
    }

    public void addEvent(SessionEvent sessionEvent) {
        this.events.add(sessionEvent);
        if (sessionEvent instanceof SittingStart) {
            this.sittingStart = (SittingStart)sessionEvent;
        }
    }

    public void removeEvent(SessionEvent sessionEvent) {
        this.events.remove(sessionEvent);
        this.findSittingStart();
    }

    protected void findSittingStart() {
        this.sittingStart = null;
        for (SessionEvent sessionEvent : this.events) {
            if (!(sessionEvent instanceof SittingStart)) continue;
            this.sittingStart = (SittingStart)sessionEvent;
        }
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        for (SessionEvent sessionEvent : this.events) {
            this.addChild(xmlWriter, sessionEvent);
        }
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        List<Element> list = XmlUtils.getElementChildren(node);
        for (Element element : list) {
            this.addEvent(SessionEvent.createFromElement(element));
        }
    }
}

