/*
 * Decompiled with CFR 0.152.
 */
package pse.result;

import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Node;
import pse.common.Presentation;
import pse.result.CompoundEvidenceIdentification;
import pse.result.EvidenceAccumulation;
import pse.result.IosLog;
import pse.result.PrimaryEvidenceIdentification;
import pse.result.ResultObject;
import pse.result.Session;
import pse.result.SittingStart;
import pse.result.VdsInfo;
import pse.result.WorkProduct;
import pse.result.WorkProductFeatureIdentification;
import pse.result.XpassSession;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
extends ResultObject {
    protected CompoundEvidenceIdentification compoundEvidenceIdentification;
    protected EvidenceAccumulation evidenceAccumulation;
    protected Presentation presentation;
    protected PrimaryEvidenceIdentification primaryEvidenceIdentification;
    protected Session session;
    protected String iipHtml = null;
    protected String vdsAssessmentIdent;
    protected String vdsFormIdent;
    protected VdsInfo vdsInfo;
    protected WorkProduct workProduct;
    protected WorkProductFeatureIdentification workProductFeatureIdentification;

    @Override
    public String getElementName() {
        return "panther-result";
    }

    public boolean hasFeedback() {
        return this.compoundEvidenceIdentification.hasFeedback();
    }

    public List<String> getFeedback() {
        return this.compoundEvidenceIdentification.getFeedback();
    }

    public String getIipHtml() {
        return this.iipHtml;
    }

    public String getMostRecentPtVersion() {
        return this.session == null ? null : this.session.getMostRecentPtVersion();
    }

    public SittingStart getMostRecentSittingStart() {
        return this.session == null ? null : this.session.getSittingStart();
    }

    public XpassSession getXpassSession() {
        return this.session == null ? null : this.session.getXpassSession();
    }

    public long getTimeRemaining() {
        return this.session.getTimeRemaining();
    }

    public void noteAutoSave(byte[] byArray, IosLog iosLog, Calendar calendar) {
        if (this.workProduct == null) {
            this.workProduct = new WorkProduct();
        }
        this.session.noteAutoSave(byArray, iosLog, calendar);
        this.workProduct.setPkaContents(byArray);
        this.workProduct.setIosLog(iosLog);
    }

    public byte[] getLatestPkaBytes() {
        return this.workProduct == null ? null : this.workProduct.getPkaContents();
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.compoundEvidenceIdentification != null || this.evidenceAccumulation != null || this.iipHtml != null || this.presentation != null || this.primaryEvidenceIdentification != null || this.session != null || this.vdsInfo != null || this.workProduct != null || this.workProductFeatureIdentification != null;
    }

    public void setIipHtml(String string) {
        this.iipHtml = string == null || string.trim().length() == 0 ? null : string;
    }

    public CompoundEvidenceIdentification getCompoundEvidenceIdentification() {
        return this.compoundEvidenceIdentification;
    }

    public CompoundEvidenceIdentification getOrCreateCompoundEvidenceIdentification() {
        if (this.compoundEvidenceIdentification == null) {
            this.compoundEvidenceIdentification = new CompoundEvidenceIdentification();
        }
        return this.compoundEvidenceIdentification;
    }

    public void setCompoundEvidenceIdentification(CompoundEvidenceIdentification compoundEvidenceIdentification) {
        this.compoundEvidenceIdentification = compoundEvidenceIdentification;
    }

    public EvidenceAccumulation getEvidenceAccumulation() {
        return this.evidenceAccumulation;
    }

    public EvidenceAccumulation getOrCreateEvidenceAccumulation() {
        if (this.evidenceAccumulation == null) {
            this.evidenceAccumulation = new EvidenceAccumulation();
        }
        return this.evidenceAccumulation;
    }

    public void setEvidenceAccumulation(EvidenceAccumulation evidenceAccumulation) {
        this.evidenceAccumulation = evidenceAccumulation;
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    public Presentation getOrCreatePresentation() {
        if (this.presentation == null) {
            this.presentation = new Presentation();
        }
        return this.presentation;
    }

    public void setPresentation(Presentation presentation) {
        this.presentation = presentation;
    }

    public PrimaryEvidenceIdentification getPrimaryEvidenceIdentification() {
        return this.primaryEvidenceIdentification;
    }

    public PrimaryEvidenceIdentification getOrCreatePrimaryEvidenceIdentification() {
        if (this.primaryEvidenceIdentification == null) {
            this.primaryEvidenceIdentification = new PrimaryEvidenceIdentification();
        }
        return this.primaryEvidenceIdentification;
    }

    public void setPrimaryEvidenceIdentification(PrimaryEvidenceIdentification primaryEvidenceIdentification) {
        this.primaryEvidenceIdentification = primaryEvidenceIdentification;
    }

    public Session getSession() {
        return this.session;
    }

    public Session getOrCreateSession() {
        if (this.session == null) {
            this.session = new Session();
        }
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getVdsAssessmentIdent() {
        return this.vdsAssessmentIdent;
    }

    public void setVdsAssessmentIdent(String string) {
        this.vdsAssessmentIdent = string;
    }

    public String getVdsFormIdent() {
        return this.vdsFormIdent;
    }

    public void setVdsFormIdent(String string) {
        this.vdsFormIdent = string;
    }

    public VdsInfo getVdsInfo() {
        return this.vdsInfo;
    }

    public VdsInfo getOrCreateVdsInfo() {
        if (this.vdsInfo == null) {
            this.vdsInfo = new VdsInfo();
        }
        return this.vdsInfo;
    }

    public void setVdsInfo(VdsInfo vdsInfo) {
        this.vdsInfo = vdsInfo;
    }

    public WorkProduct getWorkProduct() {
        return this.workProduct;
    }

    public WorkProduct getOrCreateWorkProduct() {
        if (this.workProduct == null) {
            this.workProduct = new WorkProduct();
        }
        return this.workProduct;
    }

    public void setWorkProduct(WorkProduct workProduct) {
        this.workProduct = workProduct;
    }

    public WorkProductFeatureIdentification getWorkProductFeatureIdentification() {
        return this.workProductFeatureIdentification;
    }

    public WorkProductFeatureIdentification getOrCreateWorkProductFeatureIdentification() {
        if (this.workProductFeatureIdentification == null) {
            this.workProductFeatureIdentification = new WorkProductFeatureIdentification();
        }
        return this.workProductFeatureIdentification;
    }

    public void setWorkProductFeatureIdentification(WorkProductFeatureIdentification workProductFeatureIdentification) {
        this.workProductFeatureIdentification = workProductFeatureIdentification;
    }

    @Override
    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addNullableAttribute("vds-assessment-ident", this.vdsAssessmentIdent);
        xmlWriter.addNullableAttribute("vds-form-ident", this.vdsFormIdent);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        this.addOptionalChild(xmlWriter, this.session);
        this.addOptionalChild(xmlWriter, this.workProduct);
        this.addOptionalChild(xmlWriter, this.presentation);
        this.addOptionalChild(xmlWriter, this.workProductFeatureIdentification);
        this.addOptionalChild(xmlWriter, this.primaryEvidenceIdentification);
        this.addOptionalChild(xmlWriter, this.compoundEvidenceIdentification);
        this.addOptionalChild(xmlWriter, this.evidenceAccumulation);
        this.addOptionalChild(xmlWriter, this.vdsInfo);
        if (this.iipHtml != null) {
            xmlWriter.addCDataElement("iip", this.iipHtml);
        }
    }

    @Override
    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.vdsAssessmentIdent = XmlUtils.getAttribute(node, "vds-assessment-ident");
        this.vdsFormIdent = XmlUtils.getAttribute(node, "vds-form-ident");
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        this.session = (Session)this.readOptionalChild(node, new Session());
        this.workProduct = (WorkProduct)this.readOptionalChild(node, new WorkProduct());
        this.presentation = (Presentation)this.readOptionalChild(node, new Presentation());
        this.workProductFeatureIdentification = (WorkProductFeatureIdentification)this.readOptionalChild(node, new WorkProductFeatureIdentification());
        this.primaryEvidenceIdentification = (PrimaryEvidenceIdentification)this.readOptionalChild(node, new PrimaryEvidenceIdentification());
        this.compoundEvidenceIdentification = (CompoundEvidenceIdentification)this.readOptionalChild(node, new CompoundEvidenceIdentification());
        this.evidenceAccumulation = (EvidenceAccumulation)this.readOptionalChild(node, new EvidenceAccumulation());
        this.vdsInfo = (VdsInfo)this.readOptionalChild(node, new VdsInfo());
        Node node2 = XmlUtils.getChild(node, "iip");
        this.setIipHtml(XmlUtils.getCData(node2));
    }
}

