/*
 * Decompiled with CFR 0.152.
 */
package pse.result;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pse.result.IosCommandEntry;
import pse.result.IosEventEntry;
import pse.result.IosLogEntry;
import pse.result.ResultObject;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IosLog
extends ResultObject {
    protected List<IosLogEntry> entries = new ArrayList<IosLogEntry>();
    protected int commandSize = 0;
    protected int eventSize = 0;
    protected int otherSize = 0;

    @Override
    public String getElementName() {
        return "log";
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.entries.size() > 0;
    }

    public List<IosLogEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(IosLogEntry iosLogEntry) {
        this.entries.add(iosLogEntry);
        if (iosLogEntry instanceof IosCommandEntry) {
            ++this.commandSize;
        } else if (iosLogEntry instanceof IosEventEntry) {
            ++this.eventSize;
        } else {
            ++this.otherSize;
        }
    }

    public void add(List<IosLogEntry> list) {
        for (IosLogEntry iosLogEntry : list) {
            this.addEntry(iosLogEntry);
        }
    }

    public int getCommandSize() {
        return this.commandSize;
    }

    public int getEventSize() {
        return this.eventSize;
    }

    public int getOtherSize() {
        return this.otherSize;
    }

    @Override
    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("command-size", this.commandSize);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        for (IosLogEntry iosLogEntry : this.entries) {
            this.addChild(xmlWriter, iosLogEntry);
        }
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        List<Element> list = XmlUtils.getElementChildren(node);
        for (Element element : list) {
            this.addEntry(IosLogEntry.createFromElement(element));
        }
    }
}

