/*
 * Decompiled with CFR 0.152.
 */
package pse.core;

import pse.assessment.AssessmentSmv;
import pse.assessment.PantherForm;
import pse.core.PantherEngine;
import pse.core.ScoreEngineProcessor;
import pse.model.ModelObject;
import pse.result.AbstractObservable;
import pse.result.CalculatedObject;
import pse.result.CompoundEvidenceIdentification;
import pse.result.CompoundObservable;
import pse.result.EvidenceAccumulation;
import pse.result.Result;
import pse.result.Smv;
import pse.result.VdsInfo;
import pse.result.VdsObservable;
import pse.result.VdsSmv;

public class VdsInfoGenerator
extends ScoreEngineProcessor {
    protected PantherForm form;

    public VdsInfoGenerator(PantherEngine pantherEngine, Result result, PantherForm pantherForm) {
        super(pantherEngine, result);
        this.form = pantherForm;
    }

    protected CalculatedObject performProcess() throws Exception {
        ModelObject modelObject;
        Object object;
        VdsInfo vdsInfo = this.getResult().getOrCreateVdsInfo();
        EvidenceAccumulation evidenceAccumulation = this.getResult().getEvidenceAccumulation();
        for (Smv object2 : evidenceAccumulation.getSmvs()) {
            String string = object2.getVdsIdent();
            if (string == null) continue;
            object = new VdsSmv();
            ((AbstractObservable)object).setVdsIdent(string);
            ((AbstractObservable)object).setPantherIdent(object2.getPantherIdent());
            ((AbstractObservable)object).setEarnedPoints(object2.getEarnedPoints());
            ((AbstractObservable)object).setPossiblePoints(object2.getPossiblePoints());
            modelObject = this.form.getSmvByVdsIdent(string);
            ((VdsSmv)object).setVdsProficiencyIdent(((AssessmentSmv)modelObject).getVdsProficiencyIdent(object2.getEarnedPoints()));
            vdsInfo.addVdsSmv((VdsSmv)object);
        }
        CompoundEvidenceIdentification compoundEvidenceIdentification = this.getResult().getCompoundEvidenceIdentification();
        for (CompoundObservable compoundObservable : compoundEvidenceIdentification.getCompoundObservables()) {
            object = compoundObservable.getVdsIdent();
            if (object == null) continue;
            modelObject = new VdsObservable();
            ((AbstractObservable)modelObject).setVdsIdent((String)object);
            ((AbstractObservable)modelObject).setPantherIdent(compoundObservable.getPantherIdent());
            ((AbstractObservable)modelObject).setEarnedPoints(compoundObservable.getEarnedPoints());
            ((AbstractObservable)modelObject).setPossiblePoints(compoundObservable.getPossiblePoints());
            vdsInfo.addVdsObservable((VdsObservable)modelObject);
        }
        return vdsInfo;
    }
}

