/*
 * Decompiled with CFR 0.152.
 */
package pse.core;

import apiipc.generated.system.ActivityFile;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;
import pse.core.CompoundEvidenceExtractor;
import pse.core.PresentationExtractor;
import pse.core.PrimaryEvidenceExtractor;
import pse.core.WorkProductExtractor;
import pse.core.WpfExtractor;
import pse.pt.PacketTracer;
import pse.result.IosLog;
import pse.result.Result;
import pse.result.Session;
import pse.util.general.SubmitProgress;
import pse.util.general.SubmitProgressHandler;
import pse.util.general.XmlUtils;

public class PantherResultEngine {
    protected ActivityFile activityFile;
    protected IosLog startingLog;
    protected Node proficiencyModelTopNode;
    protected PacketTracer packetTracer;
    protected Result result;
    protected Session session;
    protected String proficiencyModelXml;
    protected SubmitProgress submitProgress;

    public PantherResultEngine(Session session, PacketTracer packetTracer) {
        this(session, new IosLog(), packetTracer);
    }

    public PantherResultEngine(Session session, IosLog iosLog, PacketTracer packetTracer) {
        this(session, new IosLog(), packetTracer, new SubmitProgressHandler());
    }

    public PantherResultEngine(Session session, IosLog iosLog, PacketTracer packetTracer, SubmitProgress submitProgress) {
        this.session = session;
        this.startingLog = iosLog;
        this.packetTracer = packetTracer;
        this.submitProgress = submitProgress;
    }

    public ActivityFile getActivityFile() {
        return this.activityFile;
    }

    public IosLog getStartingLog() {
        return this.startingLog;
    }

    public Node getProficiencyModelTopNode() {
        return this.proficiencyModelTopNode;
    }

    public PacketTracer getPacketTracer() {
        return this.packetTracer;
    }

    public Result getResult() {
        return this.result;
    }

    public Session getSession() {
        return this.session;
    }

    public SubmitProgress getSubmitProgress() {
        return this.submitProgress;
    }

    public String getProficiencyModelXml() {
        return this.proficiencyModelXml;
    }

    public String getVersion() {
        return "1.0";
    }

    public Result extractResult() throws Exception {
        this.submitProgress.startGetActivityFile();
        this.activityFile = this.packetTracer.getActivityFile();
        this.submitProgress.finishGetActivityFile();
        this.submitProgress.startCreateResult();
        this.result = new Result();
        this.result.setSession(this.session);
        this.submitProgress.finishCreateResult();
        WorkProductExtractor workProductExtractor = new WorkProductExtractor(this);
        workProductExtractor.process();
        PresentationExtractor presentationExtractor = new PresentationExtractor(this);
        presentationExtractor.process();
        this.submitProgress.startScriptEngineEvaluation();
        boolean bl = this.packetTracer.evaluateScriptEngine();
        this.submitProgress.finishScriptEngineEvaluation();
        if (!bl) {
            return null;
        }
        this.submitProgress.startGetProficiencyXml();
        this.proficiencyModelXml = this.packetTracer.getProficiencyModelXml();
        try {
            this.proficiencyModelTopNode = XmlUtils.parseToNode(this.proficiencyModelXml);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("Error parsing proficiency model XML");
            System.out.println("  Description: " + sAXParseException.getMessage());
            System.out.println("  Line Number: " + sAXParseException.getLineNumber());
            System.out.println("  Col  Number: " + sAXParseException.getColumnNumber());
            throw sAXParseException;
        }
        this.submitProgress.finishGetProficiencyXml();
        WpfExtractor wpfExtractor = new WpfExtractor(this);
        wpfExtractor.process();
        PrimaryEvidenceExtractor primaryEvidenceExtractor = new PrimaryEvidenceExtractor(this);
        primaryEvidenceExtractor.process();
        CompoundEvidenceExtractor compoundEvidenceExtractor = new CompoundEvidenceExtractor(this);
        compoundEvidenceExtractor.process();
        return this.result;
    }
}

