/*
 * Decompiled with CFR 0.152.
 */
package pse.core;

import pse.assessment.AssessmentCompoundObservable;
import pse.assessment.AssessmentSmv;
import pse.assessment.PantherForm;
import pse.core.PantherEngine;
import pse.core.ScoreEngineProcessor;
import pse.result.CalculatedObject;
import pse.result.CompoundEvidenceIdentification;
import pse.result.CompoundObservable;
import pse.result.EvidenceAccumulation;
import pse.result.Result;
import pse.result.Smv;

public class EvidenceAccumulator
extends ScoreEngineProcessor {
    protected PantherForm form;

    public EvidenceAccumulator(PantherEngine pantherEngine, Result result, PantherForm pantherForm) {
        super(pantherEngine, result);
        this.form = pantherForm;
    }

    protected CalculatedObject performProcess() throws Exception {
        EvidenceAccumulation evidenceAccumulation = this.getResult().getOrCreateEvidenceAccumulation();
        CompoundEvidenceIdentification compoundEvidenceIdentification = this.getResult().getCompoundEvidenceIdentification();
        for (AssessmentSmv assessmentSmv : this.form.getSmvs()) {
            int n = 0;
            int n2 = 0;
            for (AssessmentCompoundObservable assessmentCompoundObservable : assessmentSmv.getCompoundObservables()) {
                CompoundObservable compoundObservable = compoundEvidenceIdentification.getCompoundObservableByPantherIdent(assessmentCompoundObservable.getPantherIdent());
                if (compoundObservable != null) {
                    n += compoundObservable.getEarnedPoints();
                    n2 += compoundObservable.getPossiblePoints();
                    continue;
                }
                throw new Error("Unable to find compound variable <" + assessmentCompoundObservable.getPantherIdent() + "> in current result");
            }
            Smv smv = new Smv();
            smv.setVdsIdent(assessmentSmv.getVdsIdent());
            smv.setEarnedPoints(n);
            smv.setPossiblePoints(n2);
            evidenceAccumulation.addSmv(smv);
        }
        return evidenceAccumulation;
    }
}

