/*
 * Decompiled with CFR 0.152.
 */
package pse.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import pse.configuration.Comment;
import pse.configuration.ConfigurationObject;
import pse.configuration.Content;
import pse.configuration.Fillin;
import pse.configuration.PageCollection;
import pse.util.general.Utilities;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PageObject
extends ConfigurationObject
implements Comparable<PageObject> {
    protected Map<String, Fillin> fillins = new HashMap<String, Fillin>();
    protected List<Comment> comments = new ArrayList<Comment>();
    protected Content content;
    protected String id;

    @Override
    public int compareTo(PageObject pageObject) {
        return this.id.compareTo(pageObject.getId());
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.fillins.size() > 0 || this.comments.size() > 0 || this.content != null;
    }

    public String getContentAsString(PageCollection pageCollection, Map<String, Fillin> ... mapArray) {
        return this.content.getContentAsString(pageCollection, this.combine(this.fillins, mapArray));
    }

    public Fillin getFillin(String string) {
        return this.fillins.get(string);
    }

    public void addFillin(Fillin fillin) {
        this.fillins.put(fillin.getName(), fillin);
    }

    public int getCommentsSize() {
        return this.comments.size();
    }

    public Comment getComment(int n) {
        return this.comments.get(n);
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    @Override
    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("id", this.id);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        for (Fillin configurationObject : Utilities.sort(this.fillins.values())) {
            this.addChild(xmlWriter, configurationObject);
        }
        this.addChild(xmlWriter, this.content);
        for (Comment comment : this.comments) {
            this.addChild(xmlWriter, comment);
        }
    }

    @Override
    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.id = XmlUtils.getAttribute(node, "id");
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        List<Node> list = XmlUtils.getNodeChildren(node, "fillin");
        for (Node object2 : list) {
            this.addFillin((Fillin)this.readChildFromChildNode(object2, new Fillin()));
        }
        Node node2 = XmlUtils.getChild(node, "content");
        this.setContent((Content)this.readChildFromChildNode(node2, new Content()));
        List<Node> list2 = XmlUtils.getNodeChildren(node, "comment");
        for (Node node3 : list2) {
            this.addComment((Comment)this.readChildFromChildNode(node3, new Comment()));
        }
    }
}

