/*
 * Decompiled with CFR 0.152.
 */
package pse.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import pse.configuration.ConfigurationObject;
import pse.configuration.Defaults;
import pse.configuration.Fillin;
import pse.configuration.Footer;
import pse.configuration.Header;
import pse.configuration.Page;
import pse.util.general.Utilities;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageCollection
extends ConfigurationObject {
    protected Defaults defaults;
    protected Map<String, Footer> footers = new HashMap<String, Footer>();
    protected Map<String, Header> headers = new HashMap<String, Header>();
    protected Map<String, Page> pages = new HashMap<String, Page>();
    protected String namespace;

    public Map<String, Fillin> convertStringMap(Map<String, Object> map) {
        HashMap<String, Fillin> hashMap = new HashMap<String, Fillin>();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (!(object instanceof String)) continue;
            String string2 = string;
            if (!string2.startsWith("${")) {
                string2 = "${" + string2 + "}";
            }
            hashMap.put(string2, new Fillin(string2, (String)object));
        }
        return hashMap;
    }

    @Override
    public String getElementName() {
        return "page-collection";
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.defaults != null || this.footers.size() > 0 || this.headers.size() > 0 || this.pages.size() > 0;
    }

    public Defaults getDefaults() {
        return this.defaults;
    }

    public Defaults getOrCreateDefaults() {
        if (this.defaults == null) {
            this.defaults = new Defaults();
        }
        return this.defaults;
    }

    public void setDefaults(Defaults defaults) {
        this.defaults = defaults;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getFooterContent(String string, String ... stringArray) {
        return this.getFooterContent(string, this.toFillinMap(stringArray));
    }

    public String getFooterContent(String string, Map<String, Fillin> ... mapArray) {
        return this.getFooter(string).getContentAsString(this, mapArray);
    }

    public Footer getFooter(String string) {
        return this.footers.get(string);
    }

    public void addFooter(Footer footer) {
        this.footers.put(footer.getId(), footer);
    }

    public String getHeaderContent(String string, String ... stringArray) {
        return this.getHeaderContent(string, this.getDefaults().getFillins(), this.toFillinMap(stringArray));
    }

    public String getHeaderContent(String string, Map<String, Fillin> ... mapArray) {
        return this.getHeader(string).getContentAsString(this, mapArray);
    }

    public Header getHeader(String string) {
        return this.headers.get(string);
    }

    public void addHeader(Header header) {
        this.headers.put(header.getId(), header);
    }

    public String getPageContent(String string, String ... stringArray) {
        return this.getPageContent(string, this.getDefaults().getFillins(), this.toFillinMap(stringArray));
    }

    public String getPageContent(String string, Map<String, Fillin> ... mapArray) {
        return this.getPage(string).getContentAsString(this, mapArray);
    }

    public String getEntirePageContent(String string, String ... stringArray) {
        return this.getEntirePageContent(string, this.getDefaults().getFillins(), this.toFillinMap(stringArray));
    }

    public String getEntirePageContent(String string, Map<String, Fillin> ... mapArray) {
        return this.getPage(string).getEntireContentAsString(this, mapArray);
    }

    public Page getPage(String string) {
        return this.pages.get(string);
    }

    public void addPage(Page page) {
        this.pages.put(page.getId(), page);
    }

    @Override
    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("namespace", this.namespace);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        this.addChild(xmlWriter, this.defaults);
        if (this.pages.size() > 0) {
            xmlWriter.openElement("pages");
            for (Page pageObject : Utilities.sort(this.pages.values())) {
                this.addChild(xmlWriter, pageObject);
            }
            xmlWriter.closeElement();
        }
        if (this.headers.size() > 0) {
            xmlWriter.openElement("headers");
            for (Header header : Utilities.sort(this.headers.values())) {
                this.addChild(xmlWriter, header);
            }
            xmlWriter.closeElement();
        }
        if (this.footers.size() > 0) {
            xmlWriter.openElement("footers");
            for (Footer footer : Utilities.sort(this.footers.values())) {
                this.addChild(xmlWriter, footer);
            }
            xmlWriter.closeElement();
        }
    }

    @Override
    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.namespace = XmlUtils.getAttribute(node, "namespace");
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        List<Node> list;
        Object object;
        Object object2;
        super.readChildrenFromMyNode(node);
        Node node2 = XmlUtils.getChild(node, "defaults");
        this.setDefaults((Defaults)this.readChildFromChildNode(node2, new Defaults()));
        Node node3 = XmlUtils.getChild(node, "pages");
        if (node3 != null) {
            object2 = XmlUtils.getNodeChildren(node3, "page");
            object = object2.iterator();
            while (object.hasNext()) {
                list = (Node)object.next();
                this.addPage((Page)this.readChildFromChildNode((Node)((Object)list), new Page()));
            }
        }
        if ((object2 = XmlUtils.getChild(node, "headers")) != null) {
            object = XmlUtils.getNodeChildren((Node)object2, "header");
            list = object.iterator();
            while (list.hasNext()) {
                Node node4 = (Node)list.next();
                this.addHeader((Header)this.readChildFromChildNode(node4, new Header()));
            }
        }
        if ((object = XmlUtils.getChild(node, "footers")) != null) {
            list = XmlUtils.getNodeChildren((Node)object, "footer");
            for (Node node5 : list) {
                this.addFooter((Footer)this.readChildFromChildNode(node5, new Footer()));
            }
        }
    }
}

