/*
 * Decompiled with CFR 0.152.
 */
package pse.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pse.configuration.ConfigurationObject;
import pse.configuration.ContentElement;
import pse.configuration.Fillin;
import pse.configuration.PageCollection;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Content
extends ConfigurationObject {
    protected List<ContentElement> contents = new ArrayList<ContentElement>();

    @Override
    public String getElementName() {
        return "content";
    }

    @Override
    public boolean hasChildren() {
        return this.contents.size() > 0;
    }

    public String getContentAsString(PageCollection pageCollection, Map<String, Fillin> ... mapArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ContentElement contentElement : this.contents) {
            stringBuilder.append(contentElement.getContentAsString(pageCollection, mapArray));
        }
        return this.canonicalize(stringBuilder.toString());
    }

    public int getContentsSize() {
        return this.contents.size();
    }

    public ContentElement getContent(int n) {
        return this.contents.get(n);
    }

    public List<ContentElement> getContents() {
        return this.contents;
    }

    public void addContent(ContentElement contentElement) {
        this.contents.add(contentElement);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        for (ContentElement contentElement : this.contents) {
            this.addChild(xmlWriter, contentElement);
        }
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.addContent(ContentElement.createFromNode(nodeList.item(i)));
        }
    }
}

