/*
 * Decompiled with CFR 0.152.
 */
package pse.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import pse.common.CommonObject;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public class Presentation
extends CommonObject {
    protected Map<Integer, String> pages = new HashMap<Integer, String>();

    public String getElementName() {
        return "presentation";
    }

    public boolean hasChildren() {
        return super.hasChildren() || this.pages.size() > 0;
    }

    public int getNumberOfPages() {
        return this.pages.size();
    }

    public String getPage(int n) {
        return this.pages.get(n);
    }

    public void addPage(int n, String string) {
        this.pages.put(n, string);
    }

    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        xmlWriter.openElement("instructions");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(this.pages.keySet());
        Collections.sort(arrayList);
        for (Integer n : arrayList) {
            xmlWriter.openElement("instruction-page", "page-number", n);
            xmlWriter.addCData(this.pages.get(n));
            xmlWriter.closeElement();
        }
        xmlWriter.closeElement();
    }

    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        Node node2 = XmlUtils.getChild(node, "instructions");
        List<Node> list = XmlUtils.getNodeChildren(node2, "instruction-page");
        for (Node node3 : list) {
            int n = XmlUtils.getIntAttribute(node3, "page-number", -1);
            String string = XmlUtils.getTransitiveText(node3);
            this.pages.put(n, string);
        }
    }
}

