/*
 * Decompiled with CFR 0.152.
 */
package pse.common;

import org.w3c.dom.Node;
import pse.common.CommonObject;
import pse.util.general.Utilities;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public class FileInfo
extends CommonObject {
    protected long checkSum = -1L;
    protected byte[] contents;
    protected String fileName;
    protected String fileType;
    protected int size = 0;

    public String getElementName() {
        return "file-info";
    }

    public boolean hasAttributes() {
        return true;
    }

    public boolean hasText() {
        return this.contents != null && this.contents.length > 0;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String string) {
        this.fileType = string;
    }

    public long getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(long l) {
        this.checkSum = l;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public void setContents(byte[] byArray) {
        this.contents = byArray;
        this.size = byArray.length;
        this.checkSum = Utilities.calculateCheckSum(byArray);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addOmittableAttribute("checksum", this.checkSum, -1L);
        xmlWriter.addAttribute("file-name", this.fileName);
        xmlWriter.addAttribute("file-type", this.fileType);
        xmlWriter.addOmittableAttribute("size", this.size, 0);
    }

    protected void addText(XmlWriter xmlWriter) {
        xmlWriter.addText(Utilities.encodeHex(this.contents));
    }

    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.checkSum = XmlUtils.getLongAttribute(node, "checksum", -1L);
        this.fileName = XmlUtils.getAttribute(node, "file-name");
        this.fileType = XmlUtils.getAttribute(node, "file-type");
        this.size = XmlUtils.getIntAttribute(node, "size", 0);
    }

    protected void readText(Node node) {
        String string = XmlUtils.getTransitiveText(node);
        if (string != null && string.trim().length() > 0) {
            this.setContents(Utilities.decodeHex(string.trim()));
        }
    }
}

