/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pse.assessment.AssessmentObject;
import pse.assessment.ConsistencyChecker;
import pse.assessment.SmvComparator;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProficiencyAssignment
extends AssessmentObject {
    protected List<SmvComparator> smvComparators = new ArrayList<SmvComparator>();
    protected String vdsIdent;

    @Override
    public String getElementName() {
        return "proficiency-assignment";
    }

    @Override
    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        for (SmvComparator smvComparator : this.smvComparators) {
            smvComparator.checkForConsistency(consistencyChecker);
        }
    }

    public boolean matches(int n) {
        for (SmvComparator smvComparator : this.smvComparators) {
            if (smvComparator.matches(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.smvComparators.size() > 0;
    }

    public String getVdsIdent() {
        return this.vdsIdent;
    }

    public void setVdsIdent(String string) {
        this.vdsIdent = string;
    }

    public List<SmvComparator> getSmvComparators() {
        return this.smvComparators;
    }

    public void addSmvComparator(SmvComparator smvComparator) {
        this.smvComparators.add(smvComparator);
    }

    @Override
    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("vds-ident", this.vdsIdent);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        if (!this.smvComparators.isEmpty()) {
            xmlWriter.openElement("conditionvar");
            for (SmvComparator smvComparator : this.smvComparators) {
                this.addChild(xmlWriter, smvComparator);
            }
            xmlWriter.closeElement();
        }
    }

    @Override
    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.vdsIdent = XmlUtils.getAttribute(node, "vds-ident");
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        Node node2 = XmlUtils.getChild(node, "conditionvar");
        List<Element> list = XmlUtils.getElementChildren(node2);
        for (Element element : list) {
            this.addSmvComparator(SmvComparator.createFromElement(element));
        }
    }
}

