/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import java.util.List;
import org.w3c.dom.Node;
import pse.assessment.AssessmentObject;
import pse.assessment.ConsistencyChecker;
import pse.assessment.PantherTask;
import pse.util.general.LookupList;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PantherTasks
extends AssessmentObject {
    protected LookupList<String, PantherTask> tasks = new LookupList();

    @Override
    public String getElementName() {
        return "panther-tasks";
    }

    @Override
    public boolean isTaskObject() {
        return true;
    }

    @Override
    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        for (PantherTask pantherTask : this.tasks) {
            pantherTask.checkForConsistency(consistencyChecker);
        }
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.tasks.size() > 0;
    }

    public PantherTask getFirstTask() {
        return this.tasks.get((String)false);
    }

    public PantherTask getTask(String string) {
        return this.tasks.get(string);
    }

    public List<PantherTask> getTasks() {
        return this.tasks.getList();
    }

    public void addTask(PantherTask pantherTask) {
        this.tasks.add(pantherTask.getVdsIdent(), pantherTask);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        for (PantherTask pantherTask : this.tasks) {
            this.addChild(xmlWriter, pantherTask);
        }
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        List<Node> list = XmlUtils.getNodeChildren(node, "panther-task");
        for (Node node2 : list) {
            this.addTask((PantherTask)this.readChildFromChildNode(node2, new PantherTask()));
        }
    }
}

