/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import pse.assessment.AbstractAssessmentObservable;
import pse.assessment.AssessmentCompoundObservable;
import pse.assessment.AssessmentObject;
import pse.assessment.AssessmentPrimaryObservable;
import pse.assessment.AssessmentReportingObservable;
import pse.assessment.AssessmentWorkProductFeature;
import pse.assessment.ConsistencyChecker;
import pse.assessment.PantherForm;
import pse.assessment.TaskMetaData;
import pse.result.CompoundEvidenceIdentification;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PantherTask
extends AssessmentObject {
    protected Map<String, AbstractAssessmentObservable> allObservablesByPantherIdent = new HashMap<String, AbstractAssessmentObservable>();
    protected List<AssessmentCompoundObservable> compoundObservables = new ArrayList<AssessmentCompoundObservable>();
    protected List<AssessmentPrimaryObservable> primaryObservables = new ArrayList<AssessmentPrimaryObservable>();
    protected List<AssessmentReportingObservable> reportingObservables = new ArrayList<AssessmentReportingObservable>();
    protected List<AssessmentWorkProductFeature> workProductFeatures = new ArrayList<AssessmentWorkProductFeature>();
    protected String language;
    protected String pantherIdent;
    protected String vdsIdent;
    protected TaskMetaData metaData;
    protected PantherForm pantherForm;
    protected int highestCompoundLevel;

    @Override
    public String getElementName() {
        return "panther-task";
    }

    @Override
    public boolean isTaskObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        try {
            consistencyChecker.setTaskContext(this);
            for (AssessmentCompoundObservable abstractAssessmentObservable : this.compoundObservables) {
                abstractAssessmentObservable.checkForConsistency(consistencyChecker);
            }
            for (AssessmentPrimaryObservable assessmentPrimaryObservable : this.primaryObservables) {
                assessmentPrimaryObservable.checkForConsistency(consistencyChecker);
            }
            for (AssessmentReportingObservable assessmentReportingObservable : this.reportingObservables) {
                assessmentReportingObservable.checkForConsistency(consistencyChecker);
            }
            for (AssessmentWorkProductFeature assessmentWorkProductFeature : this.workProductFeatures) {
                assessmentWorkProductFeature.checkForConsistency(consistencyChecker);
            }
            if (this.metaData != null) {
                this.metaData.checkForConsistency(consistencyChecker);
            }
        }
        finally {
            consistencyChecker.clearTaskContext();
        }
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    public boolean hasProficiency(CompoundEvidenceIdentification compoundEvidenceIdentification) {
        for (AssessmentReportingObservable assessmentReportingObservable : this.reportingObservables) {
            if (!assessmentReportingObservable.hasProficiency(compoundEvidenceIdentification)) continue;
            return true;
        }
        return false;
    }

    public AbstractAssessmentObservable getObservableByPantherIdent(String string) {
        return this.allObservablesByPantherIdent.get(string);
    }

    public List<AssessmentCompoundObservable> getTopLevelObservables() {
        ArrayList<AssessmentCompoundObservable> arrayList = new ArrayList<AssessmentCompoundObservable>();
        for (AssessmentCompoundObservable assessmentCompoundObservable : this.compoundObservables) {
            if (assessmentCompoundObservable.getLevel() != this.highestCompoundLevel) continue;
            arrayList.add(assessmentCompoundObservable);
        }
        return arrayList;
    }

    public List<AssessmentCompoundObservable> getTopLevelObservablesInOrder() {
        HashMap<Integer, AssessmentCompoundObservable> hashMap = new HashMap<Integer, AssessmentCompoundObservable>();
        ArrayList<AssessmentCompoundObservable> arrayList = new ArrayList<AssessmentCompoundObservable>();
        for (AssessmentCompoundObservable object2 : this.compoundObservables) {
            if (object2.getLevel() != this.highestCompoundLevel) continue;
            if (object2.getOrder() != -1) {
                hashMap.put(object2.getOrder(), object2);
                continue;
            }
            arrayList.add(object2);
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList3);
        for (Integer n : arrayList3) {
            arrayList2.add(hashMap.get(n));
        }
        arrayList2.addAll(arrayList);
        return arrayList2;
    }

    public AssessmentCompoundObservable getCompoundObservableByPantherIdent(String string) {
        if (string == null) {
            return null;
        }
        for (AssessmentCompoundObservable assessmentCompoundObservable : this.compoundObservables) {
            String string2 = assessmentCompoundObservable.getPantherIdent();
            if (string2 == null || !string2.equals(string)) continue;
            return assessmentCompoundObservable;
        }
        return null;
    }

    public AssessmentCompoundObservable getCompoundObservableByVdsIdent(String string) {
        if (string == null) {
            return null;
        }
        for (AssessmentCompoundObservable assessmentCompoundObservable : this.compoundObservables) {
            String string2 = assessmentCompoundObservable.getVdsIdent();
            if (string2 == null || !string2.equals(string)) continue;
            return assessmentCompoundObservable;
        }
        return null;
    }

    public AssessmentPrimaryObservable getPrimaryObservableByPantherIdent(String string) {
        if (string == null) {
            return null;
        }
        for (AssessmentPrimaryObservable assessmentPrimaryObservable : this.primaryObservables) {
            String string2 = assessmentPrimaryObservable.getPantherIdent();
            if (string2 == null || !string2.equals(string)) continue;
            return assessmentPrimaryObservable;
        }
        return null;
    }

    public AssessmentReportingObservable getReportingObservable(AssessmentCompoundObservable assessmentCompoundObservable) {
        if (assessmentCompoundObservable == null || assessmentCompoundObservable.getPantherIdent() == null) {
            return null;
        }
        String string = assessmentCompoundObservable.getPantherIdent();
        for (AssessmentReportingObservable assessmentReportingObservable : this.reportingObservables) {
            String string2 = assessmentReportingObservable.getFirstObservableReference();
            if (string2 == null || !string2.equals(string)) continue;
            return assessmentReportingObservable;
        }
        return null;
    }

    public AssessmentReportingObservable getReportingObservableByPantherIdent(String string) {
        if (string == null) {
            return null;
        }
        for (AssessmentReportingObservable assessmentReportingObservable : this.reportingObservables) {
            String string2 = assessmentReportingObservable.getPantherIdent();
            if (string2 == null || !string2.equals(string)) continue;
            return assessmentReportingObservable;
        }
        return null;
    }

    public AssessmentWorkProductFeature getWorkProductFeatureByPantherIdent(String string) {
        if (string == null) {
            return null;
        }
        for (AssessmentWorkProductFeature assessmentWorkProductFeature : this.workProductFeatures) {
            String string2 = assessmentWorkProductFeature.getPantherIdent();
            if (string2 == null || !string2.equals(string)) continue;
            return assessmentWorkProductFeature;
        }
        return null;
    }

    public List<AssessmentCompoundObservable> getCompoundObservables() {
        return this.compoundObservables;
    }

    public void addCompoundObservable(AssessmentCompoundObservable assessmentCompoundObservable) {
        this.compoundObservables.add(assessmentCompoundObservable);
        this.allObservablesByPantherIdent.put(assessmentCompoundObservable.getPantherIdent(), assessmentCompoundObservable);
    }

    public List<AssessmentPrimaryObservable> getPrimaryObservables() {
        return this.primaryObservables;
    }

    public void addPrimaryObservable(AssessmentPrimaryObservable assessmentPrimaryObservable) {
        this.primaryObservables.add(assessmentPrimaryObservable);
        this.allObservablesByPantherIdent.put(assessmentPrimaryObservable.getPantherIdent(), assessmentPrimaryObservable);
    }

    public List<AssessmentReportingObservable> getReportingObservables() {
        return this.reportingObservables;
    }

    public void addReportingObservable(AssessmentReportingObservable assessmentReportingObservable) {
        this.reportingObservables.add(assessmentReportingObservable);
        this.allObservablesByPantherIdent.put(assessmentReportingObservable.getPantherIdent(), assessmentReportingObservable);
    }

    public List<AssessmentWorkProductFeature> getWorkProductFeatures() {
        return this.workProductFeatures;
    }

    public void addWorkProductFeature(AssessmentWorkProductFeature assessmentWorkProductFeature) {
        this.workProductFeatures.add(assessmentWorkProductFeature);
        this.allObservablesByPantherIdent.put(assessmentWorkProductFeature.getPantherIdent(), assessmentWorkProductFeature);
    }

    public PantherForm getPantherForm() {
        return this.pantherForm;
    }

    public void setPantherForm(PantherForm pantherForm) {
        this.pantherForm = pantherForm;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public String getPantherIdent() {
        return this.pantherIdent;
    }

    public void setPantherIdent(String string) {
        this.pantherIdent = string;
    }

    public String getVdsIdent() {
        return this.vdsIdent;
    }

    public void setVdsIdent(String string) {
        this.vdsIdent = string;
    }

    public TaskMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(TaskMetaData taskMetaData) {
        this.metaData = taskMetaData;
    }

    public int getHighestCompoundLevel() {
        return this.highestCompoundLevel;
    }

    public void setHighestCompoundLevel(int n) {
        this.highestCompoundLevel = n;
    }

    @Override
    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("language", this.language);
        xmlWriter.addAttribute("panther-ident", this.pantherIdent);
        xmlWriter.addNullableAttribute("ravenna-ident", this.vdsIdent);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        this.addOptionalChild(xmlWriter, this.metaData);
        xmlWriter.openElement("observables");
        xmlWriter.openElement("work-product-features");
        for (AssessmentWorkProductFeature abstractAssessmentObservable : this.workProductFeatures) {
            this.addChild(xmlWriter, abstractAssessmentObservable);
        }
        xmlWriter.closeElement();
        xmlWriter.openElement("primaries");
        for (AssessmentPrimaryObservable assessmentPrimaryObservable : this.primaryObservables) {
            this.addChild(xmlWriter, assessmentPrimaryObservable);
        }
        xmlWriter.closeElement();
        xmlWriter.openElement("compounds", "top-level", this.highestCompoundLevel);
        for (AssessmentCompoundObservable assessmentCompoundObservable : this.compoundObservables) {
            this.addChild(xmlWriter, assessmentCompoundObservable);
        }
        xmlWriter.closeElement();
        xmlWriter.openElement("reporting");
        for (AssessmentReportingObservable assessmentReportingObservable : this.reportingObservables) {
            this.addChild(xmlWriter, assessmentReportingObservable);
        }
        xmlWriter.closeElement();
        xmlWriter.closeElement();
    }

    @Override
    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.language = XmlUtils.getAttribute(node, "language");
        this.pantherIdent = XmlUtils.getAttribute(node, "panther-ident");
        this.vdsIdent = XmlUtils.getAttribute(node, "ravenna-ident");
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        this.metaData = (TaskMetaData)this.readOptionalChild(node, new TaskMetaData());
        Node node2 = XmlUtils.getChild(node, "observables");
        Node node3 = XmlUtils.getChild(node2, "work-product-features");
        List<Node> list = XmlUtils.getNodeChildren(node3, "work-product-feature");
        for (Node object22 : list) {
            this.addWorkProductFeature((AssessmentWorkProductFeature)this.readChildFromChildNode(object22, new AssessmentWorkProductFeature()));
        }
        Node node4 = XmlUtils.getChild(node2, "primaries");
        list = XmlUtils.getNodeChildren(node4, "primary-observable");
        for (Node node5 : list) {
            this.addPrimaryObservable((AssessmentPrimaryObservable)this.readChildFromChildNode(node5, new AssessmentPrimaryObservable()));
        }
        Node node6 = XmlUtils.getChild(node2, "compounds");
        this.highestCompoundLevel = XmlUtils.getIntAttribute(node6, "top-level", -1);
        list = XmlUtils.getNodeChildren(node6, "compound-observable");
        for (Node node7 : list) {
            this.addCompoundObservable((AssessmentCompoundObservable)this.readChildFromChildNode(node7, new AssessmentCompoundObservable()));
        }
        Node node8 = XmlUtils.getChild(node2, "reporting");
        list = XmlUtils.getNodeChildren(node8, "reporting-observable");
        for (Node node9 : list) {
            this.addReportingObservable((AssessmentReportingObservable)this.readChildFromChildNode(node9, new AssessmentReportingObservable()));
        }
    }
}

