/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import java.io.StringWriter;
import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Node;
import pse.assessment.AssessmentObject;
import pse.assessment.ConsistencyChecker;
import pse.assessment.PantherForm;
import pse.util.general.LookupList;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PantherAssessment
extends AssessmentObject {
    protected LookupList<String, PantherForm> forms = new LookupList();
    protected Calendar modificationTime;
    protected String description;
    protected String fullDirectory;
    protected String intro;
    protected String relativeDirectory;
    protected String title;
    protected String vdsIdent;

    @Override
    public String getElementName() {
        return "assessment";
    }

    public String toXmlStringWithDocType(PantherForm pantherForm) {
        StringWriter stringWriter = new StringWriter();
        XmlWriter xmlWriter = new XmlWriter(stringWriter, "", "  ");
        this.addXmlDeclarations(xmlWriter);
        xmlWriter.startElement(this.getElementName());
        this.addAttributes(xmlWriter);
        xmlWriter.stopElement();
        xmlWriter.addOptionalTextElement("title", this.title);
        xmlWriter.addOptionalTextElement("description", this.description);
        xmlWriter.addOptionalTextElement("intro", this.intro);
        this.addChild(xmlWriter, pantherForm);
        this.addText(xmlWriter);
        xmlWriter.closeElement();
        return stringWriter.toString();
    }

    @Override
    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        for (PantherForm pantherForm : this.forms) {
            pantherForm.checkForConsistency(consistencyChecker);
        }
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.nonEmptyString(this.title) || this.nonEmptyString(this.description) || this.nonEmptyString(this.intro) || this.forms.size() > 0;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getFullDirectory() {
        return this.fullDirectory;
    }

    public void setFullDirectory(String string) {
        this.fullDirectory = string;
    }

    public String getIntro() {
        return this.intro;
    }

    public void setIntro(String string) {
        this.intro = string;
    }

    public Calendar getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(Calendar calendar) {
        this.modificationTime = calendar;
    }

    public String getRelativeDirectory() {
        return this.relativeDirectory;
    }

    public void setRelativeDirectory(String string) {
        this.relativeDirectory = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getVdsIdent() {
        return this.vdsIdent;
    }

    public void setVdsIdent(String string) {
        this.vdsIdent = string;
    }

    public PantherForm getFirstForm() {
        return this.forms.get((String)false);
    }

    public PantherForm getForm(String string) {
        return this.forms.get(string);
    }

    public List<PantherForm> getForms() {
        return this.forms.getList();
    }

    public void addForm(PantherForm pantherForm) {
        pantherForm.setAssessment(this);
        this.forms.add(pantherForm.getVdsIdent(), pantherForm);
    }

    @Override
    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("vds-ident", this.vdsIdent);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        xmlWriter.addOptionalTextElement("title", this.title);
        xmlWriter.addOptionalTextElement("description", this.description);
        xmlWriter.addOptionalTextElement("intro", this.intro);
        for (PantherForm pantherForm : this.forms) {
            this.addChild(xmlWriter, pantherForm);
        }
    }

    @Override
    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.vdsIdent = XmlUtils.getAttribute(node, "vds-ident");
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        this.title = XmlUtils.getChildText(node, "title");
        this.description = XmlUtils.getChildText(node, "description");
        this.intro = XmlUtils.getChildText(node, "intro");
        List<Node> list = XmlUtils.getNodeChildren(node, "assessmentform");
        for (Node node2 : list) {
            this.addForm((PantherForm)this.readChildFromChildNode(node2, new PantherForm()));
        }
    }
}

