/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import pse.assessment.Network;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialNetwork
extends Network {
    protected Map<Integer, String> pages = new HashMap<Integer, String>();

    @Override
    public String getElementName() {
        return "initial-network";
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.pages.size() > 0;
    }

    public String getPage(int n) {
        return this.pages.get(n);
    }

    public Map<Integer, String> getPages() {
        return this.pages;
    }

    public void addPage(int n, String string) {
        this.pages.put(n, string);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        xmlWriter.openElement("instructions");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(this.pages.keySet());
        Collections.sort(arrayList);
        for (Integer n : arrayList) {
            xmlWriter.openElement("instruction-page", "page-number", n);
            xmlWriter.addCData(this.pages.get(n));
            xmlWriter.closeElement();
        }
        xmlWriter.closeElement();
        super.addChildren(xmlWriter);
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        Node node2 = XmlUtils.getChild(node, "instructions");
        List<Node> list = XmlUtils.getNodeChildren(node2, "instruction-page");
        for (Node node3 : list) {
            int n = XmlUtils.getIntAttribute(node3, "page-number", -1);
            String string = XmlUtils.getTransitiveText(node3);
            this.pages.put(n, string);
        }
    }
}

