/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import org.w3c.dom.Node;
import pse.assessment.AssessmentObject;
import pse.assessment.ConsistencyChecker;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public class FeedbackRange
extends AssessmentObject {
    protected String message;
    protected String proficiency = null;
    protected int maximumValue;
    protected int minimumValue;

    public String getElementName() {
        return "feedback-range";
    }

    public boolean isTaskObject() {
        return true;
    }

    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
    }

    public boolean hasAttributes() {
        return true;
    }

    public boolean hasText() {
        return this.nonEmptyString(this.message);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public boolean hasProficiency() {
        return this.nonEmptyString(this.proficiency);
    }

    public String getProficiency() {
        return this.proficiency;
    }

    public void setProficiency(String string) {
        this.proficiency = string;
    }

    public boolean matches(int n) {
        return this.minimumValue <= n && n <= this.maximumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(int n) {
        this.maximumValue = n;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(int n) {
        this.minimumValue = n;
    }

    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("minimum", this.minimumValue);
        xmlWriter.addAttribute("maximum", this.maximumValue);
        xmlWriter.addNullableAttribute("proficiency", this.proficiency);
    }

    protected void addText(XmlWriter xmlWriter) {
        xmlWriter.addText(this.message);
    }

    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.minimumValue = XmlUtils.getIntAttribute(node, "minimum", -1);
        this.maximumValue = XmlUtils.getIntAttribute(node, "maximum", -1);
        this.proficiency = XmlUtils.getOptionalAttribute(node, "proficiency", null);
    }

    protected void readText(Node node) {
        this.message = XmlUtils.getTransitiveText(node);
    }
}

