/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import pse.assessment.AbstractAssessmentObservable;
import pse.assessment.ConsistencyChecker;
import pse.assessment.FeedbackRange;
import pse.result.CompoundEvidenceIdentification;
import pse.result.CompoundObservable;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssessmentReportingObservable
extends AbstractAssessmentObservable {
    protected List<FeedbackRange> feedbackRanges = new ArrayList<FeedbackRange>();
    protected String feedbackRubric;

    @Override
    public String getElementName() {
        return "reporting-observable";
    }

    @Override
    public String getDescriptiveName() {
        return "Reporting Observable";
    }

    @Override
    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        super.checkForConsistency(consistencyChecker);
        for (FeedbackRange feedbackRange : this.feedbackRanges) {
            feedbackRange.checkForConsistency(consistencyChecker);
        }
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.feedbackRanges.size() > 0 || this.nonEmptyString(this.feedbackRubric);
    }

    public List<FeedbackRange> getFeedbackRanges() {
        return this.feedbackRanges;
    }

    public FeedbackRange getMatchingRange(int n) {
        for (FeedbackRange feedbackRange : this.feedbackRanges) {
            if (!feedbackRange.matches(n)) continue;
            return feedbackRange;
        }
        return null;
    }

    public FeedbackRange getMatchingRange(CompoundEvidenceIdentification compoundEvidenceIdentification) {
        CompoundObservable compoundObservable;
        String string = this.getFirstObservableReference();
        if (string != null && (compoundObservable = compoundEvidenceIdentification.getCompoundObservableByPantherIdent(string)) != null) {
            return this.getMatchingRange(compoundObservable.getEarnedPoints());
        }
        return null;
    }

    public String getProficiency(CompoundEvidenceIdentification compoundEvidenceIdentification) {
        FeedbackRange feedbackRange = this.getMatchingRange(compoundEvidenceIdentification);
        return feedbackRange == null ? null : feedbackRange.getProficiency();
    }

    public boolean hasProficiency(CompoundEvidenceIdentification compoundEvidenceIdentification) {
        FeedbackRange feedbackRange = this.getMatchingRange(compoundEvidenceIdentification);
        return feedbackRange != null && feedbackRange.hasProficiency();
    }

    public void addFeedbackRange(FeedbackRange feedbackRange) {
        this.feedbackRanges.add(feedbackRange);
    }

    public String getFeedbackRubric() {
        return this.feedbackRubric;
    }

    public void setFeedbackRubric(String string) {
        this.feedbackRubric = string;
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        List<Node> list = XmlUtils.getNodeChildren(node, "feedback-range");
        for (Node node2 : list) {
            this.addFeedbackRange((FeedbackRange)this.readChildFromChildNode(node2, new FeedbackRange()));
        }
        this.feedbackRubric = XmlUtils.getChildText(node, "feedback-rubric");
    }

    @Override
    protected void addPreObservableRefChildren(XmlWriter xmlWriter) {
        for (FeedbackRange feedbackRange : this.feedbackRanges) {
            this.addChild(xmlWriter, feedbackRange);
        }
    }

    @Override
    protected void addPreClaimChildren(XmlWriter xmlWriter) {
        xmlWriter.addCDataElement("feedback-rubric", this.feedbackRubric);
    }
}

