/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import org.w3c.dom.Node;
import pse.assessment.AbstractAssessmentObservable;
import pse.assessment.ConsistencyChecker;
import pse.assessment.ObservableMetaData;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public class AssessmentCompoundObservable
extends AbstractAssessmentObservable {
    protected ObservableMetaData metaData;
    protected int level;
    protected int maximumPoints;
    protected int order;

    public String getElementName() {
        return "compound-observable";
    }

    public String getDescriptiveName() {
        return "Compound Observable";
    }

    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        super.checkForConsistency(consistencyChecker);
        if (this.metaData != null) {
            this.metaData.checkForConsistency(consistencyChecker);
        }
    }

    public boolean hasAttributes() {
        return true;
    }

    public boolean hasChildren() {
        return super.hasChildren() || this.metaData != null;
    }

    public ObservableMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(ObservableMetaData observableMetaData) {
        this.metaData = observableMetaData;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getMaximumPoints() {
        return this.maximumPoints;
    }

    public void setMaximumPoints(int n) {
        this.maximumPoints = n;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addOmittableAttribute("level", this.level, -1);
        xmlWriter.addOmittableAttribute("maximum-points", this.maximumPoints, -1);
        xmlWriter.addOmittableAttribute("order", this.order, -1);
    }

    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.maximumPoints = XmlUtils.getIntAttribute(node, "maximum-points", -1);
        this.level = XmlUtils.getIntAttribute(node, "level", -1);
        this.order = XmlUtils.getIntAttribute(node, "order", -1);
    }

    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        Node node2 = XmlUtils.getChild(node, "observable-metadata");
        this.setMetaData((ObservableMetaData)this.readChildFromChildNode(node2, new ObservableMetaData()));
    }

    protected String getVdsIdentAttributeName() {
        return "ravenna-ident";
    }

    protected void addPreClaimChildren(XmlWriter xmlWriter) {
        this.addChild(xmlWriter, this.metaData);
    }
}

