/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import pse.assessment.AssessmentObject;
import pse.assessment.ConsistencyChecker;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAssessmentObservable
extends AssessmentObject {
    protected List<String> claims = new ArrayList<String>();
    protected List<String> observableReferences = new ArrayList<String>();
    protected String description;
    protected String expression;
    protected String name;
    protected String pantherIdent;
    protected String type;
    protected String value;
    protected String vdsIdent;

    @Override
    public boolean isTaskObject() {
        return true;
    }

    public abstract String getDescriptiveName();

    @Override
    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        for (String string : this.observableReferences) {
            AbstractAssessmentObservable abstractAssessmentObservable = consistencyChecker.getObservable(string);
            if (abstractAssessmentObservable != null) continue;
            consistencyChecker.missingObservable(this, string);
        }
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.claims.size() > 0 || this.observableReferences.size() > 0 || this.nonEmptyString(this.description) || this.nonEmptyString(this.expression) || this.nonEmptyString(this.name) || this.nonEmptyString(this.value);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) {
        this.expression = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPantherIdent() {
        return this.pantherIdent;
    }

    public void setPantherIdent(String string) {
        this.pantherIdent = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getVdsIdent() {
        return this.vdsIdent;
    }

    public void setVdsIdent(String string) {
        this.vdsIdent = string;
    }

    public List<String> getClaims() {
        return this.claims;
    }

    public void addClaim(String string) {
        this.claims.add(string);
    }

    public String getFirstObservableReference() {
        return this.observableReferences == null ? null : this.observableReferences.get(0);
    }

    public List<String> getObservableReferences() {
        return this.observableReferences;
    }

    public void addObservableReference(String string) {
        this.observableReferences.add(string);
    }

    @Override
    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("panther-ident", this.pantherIdent);
        xmlWriter.addNullableAttribute("type", this.type);
        xmlWriter.addNullableAttribute(this.getVdsIdentAttributeName(), this.vdsIdent);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        xmlWriter.addOptionalCDataElement("name", this.name);
        xmlWriter.addOptionalCDataElement("description", this.description);
        xmlWriter.addOptionalCDataElement("expression", this.expression);
        xmlWriter.addOptionalCDataElement("value", this.value);
        this.addPreObservableRefChildren(xmlWriter);
        for (String string : this.observableReferences) {
            xmlWriter.addElement("observable-ref", "panther-ident", string);
        }
        this.addPreClaimChildren(xmlWriter);
        for (String string : this.claims) {
            xmlWriter.addElement("claim", "id", string);
        }
    }

    @Override
    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.pantherIdent = XmlUtils.getAttribute(node, "panther-ident");
        this.type = XmlUtils.getAttribute(node, "type");
        this.vdsIdent = XmlUtils.getAttribute(node, this.getVdsIdentAttributeName());
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        String string;
        super.readChildrenFromMyNode(node);
        this.name = XmlUtils.getChildText(node, "name");
        this.description = XmlUtils.getChildText(node, "description");
        this.expression = XmlUtils.getChildText(node, "expression");
        this.value = XmlUtils.getChildText(node, "value");
        List<Node> list = XmlUtils.getNodeChildren(node, "observable-ref");
        for (Node node2 : list) {
            string = XmlUtils.getAttribute(node2, "panther-ident");
            this.addObservableReference(string);
        }
        list = XmlUtils.getNodeChildren(node, "claim");
        for (Node node2 : list) {
            string = XmlUtils.getAttribute(node2, "id");
            this.addClaim(string);
        }
    }

    protected String getVdsIdentAttributeName() {
        return "vds-ident";
    }

    protected void addPreObservableRefChildren(XmlWriter xmlWriter) {
    }

    protected void addPreClaimChildren(XmlWriter xmlWriter) {
    }
}

