/*
 * Decompiled with CFR 0.152.
 */
package panther.xp;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JApplet;
import org.w3c.dom.Node;
import panther.util.crypto.ObfuscateDecode;
import panther.util.crypto.ObfuscateEncode;
import panther.util.general.Constants;
import panther.util.general.ErrorUtils;
import panther.util.general.StringUtils;
import panther.util.general.XMLUtils;
import panther.util.net.MimeContent;
import panther.util.unicon.Base64Encode;
import panther.xp.PantherAssessmentState;
import panther.xp.XPassUnavailableException;
import panther.xp.XPassUtils;
import pse.pt.PacketTracer;
import pse.util.general.ApplicationError;
import pse.util.general.ThreadUtils;
import pse.util.general.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPass {
    protected JApplet applet;
    protected String activityId;
    protected String authorizationString;
    protected String examId;
    protected String myId;
    protected String scenarioId;
    protected String serverHostAndPort;
    protected String serverHostPortAndTomcatContext;
    protected String sessionId;
    protected String timeLimitString;
    protected String token = "None";
    protected String tomcatContext;
    protected String userId;
    protected boolean inAutoSave = false;
    protected boolean inFinalSave = false;
    protected boolean isUp = true;
    protected boolean useCompression;
    protected boolean useConnectivityTestEvaluation;
    protected boolean useEncryption;
    protected int generation = 0;
    protected int maximumSessionPieceSize = 50000;
    protected long lastSuccessfulAccess = -1L;
    protected long lastUnsuccessfulAccess = -1L;
    protected long timeAllowedTotal;

    public XPass(String string) {
        this.myId = string;
    }

    public boolean checkHttpd() {
        try {
            URL uRL = new URL("http://" + this.serverHostAndPort + "/success.html");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            this.addAuthorization(httpURLConnection);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            skeletonapplet.Utilities.logPrintln("access to success.html ... responseCode = " + n);
            return n == 200;
        }
        catch (Throwable throwable) {
            skeletonapplet.Utilities.logPrintln("access to success.html ... t = " + throwable);
            Utilities.check(throwable);
            return false;
        }
    }

    public boolean checkTomcat() {
        try {
            URL uRL = new URL("http://" + this.serverHostPortAndTomcatContext + "/Success");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            this.addAuthorization(httpURLConnection);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            skeletonapplet.Utilities.logPrintln("access to Success ... responseCode = " + n);
            return n == 200;
        }
        catch (Throwable throwable) {
            skeletonapplet.Utilities.logPrintln("access to Success ... t = " + throwable);
            Utilities.check(throwable);
            return false;
        }
    }

    public boolean checkXPass() {
        return this.checkHttpd() && this.checkTomcat();
    }

    public void clearAuthorization() {
        this.authorizationString = null;
    }

    public PantherAssessmentState getAssessmentState() throws Exception {
        URL uRL = null;
        try {
            uRL = new URL(Constants.fillInUrl("http://FOO1/PTAssessmentState.action?SESSION_ID=FOO2&SOURCE=FOO3", this.serverHostPortAndTomcatContext, this.sessionId, this.myId));
        }
        catch (Throwable throwable) {
            throw new XPassUnavailableException("Unable to create URL to retrieve assessment state", throwable);
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        this.makeConnection(httpURLConnection, uRL);
        int n = httpURLConnection.getResponseCode();
        skeletonapplet.Utilities.logPrintln("responseCode = " + n);
        if (n != 200) {
            skeletonapplet.Utilities.logPrintln("throw response code error");
            throw new XPassUnavailableException("Received response code " + n + " while retrieving assessment state XML");
        }
        PantherAssessmentState pantherAssessmentState = this.createAssessmentState(httpURLConnection);
        if (pantherAssessmentState == null) {
            throw new XPassUnavailableException("Unable to retrieve assessment state XML");
        }
        skeletonapplet.Utilities.logPrintln(pantherAssessmentState.toString());
        return pantherAssessmentState;
    }

    public URL getExamURL() throws MalformedURLException, UnsupportedEncodingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.sessionId);
        String string = ObfuscateEncode.encode(arrayList);
        return new URL(Constants.fillInUrl("http://FOO1/PTExam.action?MESSAGE=FOO2&SOURCE=FOO3&TOKEN=FOO4", this.serverHostPortAndTomcatContext, string, this.myId, this.token));
    }

    public URL getGeneralErrorURL() throws MalformedURLException {
        return new URL(Constants.fillInUrl("http://FOO1/PTGeneralError.action?SESSION_ID=FOO2&SOURCE=FOO3", this.serverHostPortAndTomcatContext, this.sessionId, this.myId));
    }

    public URL getGeneralErrorURL(URL uRL, String string, Throwable throwable, Map<String, String> map) throws MalformedURLException {
        try {
            String string2 = null;
            string2 = this.serverHostPortAndTomcatContext == null || this.sessionId == null ? Constants.fillInUrl("PTGeneralError.action?errortype=FOO1&throwablemessage=FOO2&SOURCE=FOO3&TOKEN=FOO4", string, throwable.getMessage(), this.myId, this.token) : Constants.fillInUrl("http://FOO1/PTGeneralError.action?SESSION_ID=FOO2&SOURCE=FOO3&errortype=FOO4&throwablemessage=FOO5", this.serverHostPortAndTomcatContext, this.sessionId, this.myId, string, throwable.getMessage());
            if (map != null) {
                for (String string3 : map.keySet()) {
                    string2 = string2 + "&" + string3 + "=" + map.get(string3);
                }
            }
            if (this.serverHostPortAndTomcatContext == null || this.sessionId == null) {
                return new URL(uRL, string2);
            }
            return new URL(string2);
        }
        catch (Throwable throwable2) {
            return this.getGeneralErrorURL();
        }
    }

    public URL getInterruptedURL() throws MalformedURLException {
        return new URL(Constants.fillInUrl("http://FOO1/PTInterrupted.action?SESSION_ID=FOO2&SOURCE=FOO3", this.serverHostPortAndTomcatContext, this.sessionId, this.myId));
    }

    public URL getNoPacketTracerURL() throws MalformedURLException {
        return new URL(Constants.fillInUrl("http://FOO1/PTGeneralError.action?errortype=nopackettracer&SESSION_ID=FOO2&SOURCE=FOO3", this.serverHostPortAndTomcatContext, this.sessionId, this.myId));
    }

    public URL getPtaMissingURL(String string, String string2) throws MalformedURLException {
        return new URL(Constants.fillInUrl("http://FOO1/PTGeneralError.action?errortype=ptamissing&SESSION_ID=FOO2&SOURCE=FOO3&name=FOO4&location=FOO5", this.serverHostPortAndTomcatContext, this.sessionId, this.myId, string, string2));
    }

    public String getSessionXml() throws XPassUnavailableException, Exception {
        this.checkStatus();
        Throwable throwable = null;
        for (int i = 1; i <= 5; ++i) {
            try {
                skeletonapplet.Utilities.logPrintln("\n\nBefore innerGetSessionXml()");
                String string = this.innerGetSessionXml();
                skeletonapplet.Utilities.logPrintln("After innerGetSessionXml()\n\n");
                if (string == null) continue;
                return string;
            }
            catch (Throwable throwable2) {
                ErrorUtils.check(throwable2);
                skeletonapplet.Utilities.logPrintln("Throwable = " + throwable2);
                throwable = throwable2;
            }
        }
        throw new ApplicationError.GetSessionXml("Unable to read session XML even after 5 attempts.", throwable);
    }

    public URL getSubmitURL() throws MalformedURLException {
        return new URL(Constants.fillInUrl("http://FOO1/PTSubmit.action?SESSION_ID=FOO2&SOURCE=FOO3", this.serverHostPortAndTomcatContext, this.sessionId, this.myId));
    }

    public long getTimeAllowed() {
        return this.timeAllowedTotal;
    }

    public URL getUnscorableURL() throws MalformedURLException {
        return new URL(Constants.fillInUrl("http://FOO1/PTGeneralError.action?errortype=packettracerscoring&SESSION_ID=FOO2&SOURCE=FOO3", this.serverHostPortAndTomcatContext, this.sessionId, this.myId));
    }

    public String getUniqueUserAssessmentMarker() {
        return this.sessionId;
    }

    public void initialize(JApplet jApplet, String string) {
        this.applet = jApplet;
        if (string == null) {
            throw new ApplicationError.ParameterProcessing("Academy Connection initialization message is null");
        }
        List<String> list = null;
        try {
            list = ObfuscateDecode.decode(string);
        }
        catch (Throwable throwable) {
            Utilities.checkIgnore(throwable);
            throw new ApplicationError.ParameterProcessing("Error breaking down applet key");
        }
        if (list.size() != 13) {
            throw new ApplicationError.ParameterProcessing(Constants.fillIn("Applet key size mismatch: size is FOO1, should be FOO2", list.size(), 13));
        }
        this.serverHostAndPort = list.get(0);
        this.sessionId = list.get(1);
        this.userId = list.get(2);
        this.tomcatContext = list.get(3);
        this.scenarioId = list.get(5);
        this.activityId = list.get(6);
        this.timeLimitString = list.get(7);
        this.examId = list.get(8);
        this.useCompression = Boolean.parseBoolean(list.get(9));
        this.useEncryption = Boolean.parseBoolean(list.get(10));
        this.useConnectivityTestEvaluation = Boolean.parseBoolean(list.get(11));
        this.token = list.get(12);
        PacketTracer.useConnectivityTestEvaluation(this.useConnectivityTestEvaluation);
        if (this.serverHostAndPort == null) {
            this.serverHostPortAndTomcatContext = null;
        } else {
            this.serverHostPortAndTomcatContext = this.tomcatContext == null ? this.serverHostAndPort : StringUtils.withoutTrailing(this.serverHostAndPort, '/') + "/" + StringUtils.withoutLeading(this.tomcatContext, '/');
            this.serverHostPortAndTomcatContext = StringUtils.withoutTrailing(this.serverHostPortAndTomcatContext, '/');
        }
        this.timeAllowedTotal = 0L;
        try {
            this.timeAllowedTotal = Long.parseLong(this.timeLimitString);
        }
        catch (Throwable throwable) {
            Utilities.checkIgnore(throwable);
            throw new ApplicationError.ParameterProcessing(Constants.fillIn("Unable to parse time allowed string: <FOO1>", this.timeLimitString));
        }
        try {
            String string2 = jApplet.getParameter("maxsessionpiecesize");
            this.maximumSessionPieceSize = Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            this.maximumSessionPieceSize = 50000;
        }
    }

    public boolean isInAutoSave() {
        return this.inAutoSave;
    }

    public boolean isInFinalSave() {
        return this.inFinalSave;
    }

    public boolean isUp() {
        return this.isUp;
    }

    public void putAutoSaveXml(String string) throws Throwable {
        this.putAutoSaveXml(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAutoSaveXml(String string, boolean bl) throws Throwable {
        if (this.isInFinalSave()) {
            return;
        }
        if (this.isInAutoSave()) {
            if (bl) {
                while (this.isInAutoSave()) {
                    ThreadUtils.guaranteedSleep(25L);
                }
            } else {
                return;
            }
        }
        try {
            this.inAutoSave = true;
            this.putSessionXml(string, "Autosave", "http://FOO1/PTAutoSavePiecesPut.action?SESSION_ID=FOO2&SOURCE=FOO3&SIZE=FOO4&CHECKSUM=FOO5&GENERATION=FOO6&NUMBER=FOO7&TOTAL=FOO8&TRY=FOO9");
        }
        finally {
            this.inAutoSave = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFinalXml(String string) throws Throwable {
        while (this.isInAutoSave()) {
            ThreadUtils.guaranteedSleep(25L);
        }
        try {
            this.inFinalSave = true;
            this.putSessionXml(string, "Result", "http://FOO1/PTFinalPiecesPut.action?SESSION_ID=FOO2&SOURCE=FOO3&SIZE=FOO4&CHECKSUM=FOO5&GENERATION=FOO6&NUMBER=FOO7&TOTAL=FOO8&TRY=FOO9");
        }
        finally {
            this.inFinalSave = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putUnscorableXml(String string) throws Throwable {
        while (this.isInAutoSave()) {
            ThreadUtils.guaranteedSleep(25L);
        }
        try {
            this.inFinalSave = true;
            this.putSessionXml(string, "Unscorable", "http://FOO1/PTUnscorablePiecesPut.action?SESSION_ID=FOO2&SOURCE=FOO3&SIZE=FOO4&CHECKSUM=FOO5&GENERATION=FOO6&NUMBER=FOO7&TOTAL=FOO8&TRY=FOO9");
        }
        finally {
            this.inFinalSave = false;
        }
    }

    public boolean reestablish() {
        if (this.checkXPass()) {
            this.markAsUp();
            return true;
        }
        return false;
    }

    public void register() throws Exception {
        URL uRL = new URL(Constants.fillInUrl("http://FOO1/PTRegister.action?SESSION_ID=FOO2&SOURCE=FOO3", this.serverHostPortAndTomcatContext, this.sessionId, this.myId));
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        this.makeConnection(httpURLConnection, uRL);
        int n = httpURLConnection.getResponseCode();
        skeletonapplet.Utilities.logPrintln("register responseCode = " + n);
    }

    public boolean reestablish(long l, long l2) {
        long l3;
        long l4 = l3 = System.currentTimeMillis();
        while (l4 <= l3 + l) {
            if (this.reestablish()) {
                return true;
            }
            ThreadUtils.guaranteedSleep(l2);
            l4 = System.currentTimeMillis();
        }
        return false;
    }

    public void reportGeneralError(URL uRL, String string, Throwable throwable) throws XPassUnavailableException {
        this.reportGeneralError(uRL, string, throwable, null);
    }

    public void reportGeneralError(URL uRL, String string, Throwable throwable, Map<String, String> map) throws XPassUnavailableException {
        this.checkStatus();
        try {
            URL uRL2 = null;
            uRL2 = this.serverHostAndPort == null || this.sessionId == null ? new URL(uRL, "PTReportError.action") : new URL(Constants.fillInUrl("http://FOO1/PTReportError.action?SESSION_ID=FOO2&SOURCE=FOO3", this.serverHostPortAndTomcatContext, this.sessionId, this.myId));
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            try {
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(httpURLConnection.getOutputStream()));
                this.addPostParameter(printWriter, "errortype", string);
                if (throwable != null) {
                    this.addAdditionalPostParameter(printWriter, "throwablemessage", throwable.getMessage());
                    this.addAdditionalPostParameter(printWriter, "throwablestacktrace", Utilities.stackTrace(throwable));
                }
                if (map != null) {
                    for (String string2 : map.keySet()) {
                        this.addAdditionalPostParameter(printWriter, string2, map.get(string2));
                    }
                }
                this.addAdditionalPostParameter(printWriter, "javaconsole", Utilities.buffer.toString());
                printWriter.flush();
            }
            catch (IOException iOException) {
                this.markAsDown();
                throw new XPassUnavailableException("Unable to write session XML to Academy Connection", iOException);
            }
            this.makeConnection(httpURLConnection, uRL2);
            Utilities.read(httpURLConnection.getInputStream());
            httpURLConnection.getInputStream().close();
        }
        catch (Throwable throwable2) {
            Utilities.checkIgnore(throwable2);
            throw new Error("Unable to continue processing", throwable2);
        }
    }

    public void setAuthorization(String string, String string2) throws Exception {
        Base64Encode base64Encode = new Base64Encode();
        this.authorizationString = "Basic " + Utilities.safeUrlEncode(base64Encode.encodeString(string + ":" + string2));
    }

    protected void addAdditionalPostParameter(PrintWriter printWriter, String string, String string2) {
        printWriter.print("&");
        this.addPostParameter(printWriter, string, string2);
    }

    protected void addAuthorization(HttpURLConnection httpURLConnection) {
        if (this.authorizationString != null) {
            httpURLConnection.setRequestProperty("Authorization", this.authorizationString);
        }
    }

    protected void addPostParameter(PrintWriter printWriter, String string, String string2) {
        printWriter.print(string);
        printWriter.print("=");
        printWriter.print(Utilities.safeUrlEncode(string2));
    }

    protected synchronized int advanceGeneration() {
        ++this.generation;
        skeletonapplet.Utilities.logPrintln("\n\ngeneration = " + this.generation + "\n\n");
        return this.generation;
    }

    protected void checkStatus() throws XPassUnavailableException {
        if (!this.isUp()) {
            if (this.checkXPass()) {
                this.markAsUp();
            } else {
                throw new XPassUnavailableException("Academy Connection server is still down");
            }
        }
    }

    protected PantherAssessmentState createAssessmentState(HttpURLConnection httpURLConnection) throws Exception {
        PantherAssessmentState pantherAssessmentState = new PantherAssessmentState();
        Node node = null;
        try {
            String string = Utilities.read(httpURLConnection.getInputStream());
            httpURLConnection.getInputStream().close();
            node = XMLUtils.parseToNode("Academy Connection", string);
        }
        catch (Throwable throwable) {
            ErrorUtils.checkSwallow(throwable);
            pantherAssessmentState.setMessage("Can't parse state XML:  " + throwable.getMessage());
            pantherAssessmentState.setStackTrace(ErrorUtils.stackTrace(throwable));
            pantherAssessmentState.setErrorType("unparseablexml");
            return pantherAssessmentState;
        }
        pantherAssessmentState.fromXml(node);
        return pantherAssessmentState;
    }

    protected String innerGetSessionXml() throws Exception {
        URL uRL = new URL(Constants.fillInUrl("http://FOO1/PTSessionGet.action?SESSION_ID=FOO2&SOURCE=FOO3", this.serverHostPortAndTomcatContext, this.sessionId, this.myId));
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        this.makeConnection(httpURLConnection, uRL);
        return XPassUtils.readSessionInfo(httpURLConnection.getContentType(), httpURLConnection.getInputStream(), this.useCompression, this.useEncryption);
    }

    protected void makeConnection(HttpURLConnection httpURLConnection, URL uRL) throws XPassUnavailableException {
        try {
            this.addAuthorization(httpURLConnection);
            httpURLConnection.connect();
            this.markAsUp();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            skeletonapplet.Utilities.logPrintln("e = " + socketTimeoutException);
            this.markAsDown();
            throw new XPassUnavailableException("Socket timed out during request to " + uRL, socketTimeoutException);
        }
        catch (IOException iOException) {
            skeletonapplet.Utilities.logPrintln("e = " + iOException);
            this.markAsDown();
            throw new XPassUnavailableException("IO Exception during request to " + uRL, iOException);
        }
    }

    protected void markAsDown() {
        this.isUp = false;
        this.lastUnsuccessfulAccess = System.currentTimeMillis();
    }

    protected void markAsUp() {
        this.isUp = true;
        this.lastSuccessfulAccess = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean putSessionDataChunk(byte[] byArray, byte[] byArray2, String string, int n, int n2, int n3, int n4) throws Throwable {
        if (n < this.generation) {
            throw new ApplicationError.SaveGeneration("myGeneration = " + n + ", but current generation is " + this.generation);
        }
        int n5 = byArray2.length;
        long l = Utilities.calculateCheckSum(byArray2);
        HttpURLConnection httpURLConnection = null;
        boolean bl = false;
        try {
            URL uRL = new URL(Constants.fillInUrl(string, this.serverHostPortAndTomcatContext, this.sessionId, this.myId, n5, l, n, n2, n3, n4));
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.addRequestProperty("content-type", MimeContent.getContentType(byArray));
            this.addAuthorization(httpURLConnection);
            httpURLConnection.setDoOutput(true);
            XPassUtils.writeSessionInfo(byArray, byArray2, httpURLConnection.getOutputStream());
            httpURLConnection.getOutputStream().flush();
            this.makeConnection(httpURLConnection, uRL);
            int n6 = httpURLConnection.getResponseCode();
            PantherAssessmentState pantherAssessmentState = this.createAssessmentState(httpURLConnection);
            this.verifyAssessmentState(pantherAssessmentState);
            bl = n6 == 200 && pantherAssessmentState != null && pantherAssessmentState.isUploadSuccessful();
        }
        catch (IOException iOException) {
            this.markAsDown();
            throw new XPassUnavailableException("Unable to write session XML to XPass", iOException);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            if (throwable instanceof ApplicationError.AppletOvertaken || throwable instanceof ApplicationError.AssessmentComplete || throwable instanceof ApplicationError.SaveGeneration) {
                throw throwable;
            }
        }
        finally {
            if (httpURLConnection != null) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                }
                try {
                    if (httpURLConnection.getOutputStream() != null) {
                        httpURLConnection.getOutputStream().close();
                    }
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                }
                try {
                    if (httpURLConnection.getInputStream() != null) {
                        httpURLConnection.getInputStream().close();
                    }
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                }
            }
        }
        return bl;
    }

    protected boolean putSessionPiece(byte[] byArray, byte[] byArray2, String string, int n, int n2, int n3) throws Throwable {
        if (n < this.generation) {
            throw new ApplicationError.SaveGeneration("myGeneration = " + n + ", but current generation is " + this.generation);
        }
        Throwable throwable = null;
        for (int i = 1; i <= 5; ++i) {
            try {
                if (!this.putSessionDataChunk(byArray, byArray2, string, n, n2, n3, i)) continue;
                return true;
            }
            catch (Throwable throwable2) {
                ErrorUtils.check(throwable2);
                if (throwable2 instanceof ApplicationError.AppletOvertaken || throwable2 instanceof ApplicationError.AssessmentComplete || throwable2 instanceof ApplicationError.SaveGeneration) {
                    throw throwable2;
                }
                throwable = throwable2;
            }
        }
        throw new XPassUnavailableException("Unable to write a session XML piece even after 5 attempts.", throwable);
    }

    protected void putSessionPiecesXml(String string, String string2, int n) throws Throwable {
        this.checkStatus();
        if (n < this.generation) {
            throw new ApplicationError.SaveGeneration("myGeneration = " + n + ", but current generation is " + this.generation);
        }
        byte[] byArray = MimeContent.generateSeparator();
        byte[] byArray2 = XPassUtils.convertStringToDataBytes(string, this.useCompression, this.useEncryption);
        int n2 = byArray2.length / this.maximumSessionPieceSize;
        if (byArray2.length % this.maximumSessionPieceSize > 0) {
            ++n2;
        }
        int n3 = 1;
        int n4 = 0;
        int n5 = Math.min(this.maximumSessionPieceSize, byArray2.length - n4);
        while (n4 < byArray2.length && n5 > 0) {
            byte[] byArray3 = new byte[n5];
            for (int i = 0; i < n5; ++i) {
                byArray3[i] = byArray2[n4 + i];
            }
            this.putSessionPiece(byArray, byArray3, string2, n, n3, n2);
            ++n3;
            n5 = Math.min(this.maximumSessionPieceSize, byArray2.length - (n4 += n5));
        }
    }

    protected void putSessionXml(String string, String string2, String string3) throws Throwable {
        this.checkStatus();
        int n = this.advanceGeneration();
        skeletonapplet.Utilities.logPrintln("\n\nmyGeneration = " + n + "\n\n");
        this.putSessionPiecesXml(string, string3, n);
    }

    protected void verifyAssessmentState(PantherAssessmentState pantherAssessmentState) {
        if (pantherAssessmentState != null && pantherAssessmentState.isError()) {
            String string = pantherAssessmentState.getErrorType();
            if (string.equals("appletovertaken")) {
                throw new ApplicationError.AppletOvertaken();
            }
            if (string.equals("assessmentcomplete")) {
                throw new ApplicationError.AssessmentComplete();
            }
            if (string.equals("unparseablexml")) {
                throw new Error("Couldn't parse assessment state XML");
            }
        }
    }
}

