/*
 * Decompiled with CFR 0.152.
 */
package panther.xp;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Node;
import panther.util.general.ErrorUtils;
import panther.util.general.XMLUtils;
import panther.util.general.XMLUtils2;

public class PantherAssessmentState {
    protected String action;
    protected String errorType;
    protected Date lastSaveDate;
    protected long lastSaveSize = -1L;
    protected String lastSaveType = "initial";
    protected String message;
    protected String phase = "new";
    protected int httpReturnCode = -1;
    protected String sessionId;
    protected String source;
    protected String stackTrace;
    public static final String ERROR_TYPE_APPLET_OVERTAKEN = "appletovertaken";
    public static final String ERROR_TYPE_ASSESSMENT_COMPLETE = "assessmentcomplete";
    public static final String ERROR_TYPE_MISCELLANEOUS = "miscellaneous";
    public static final String ERROR_TYPE_UNPARSEABLE_XML = "unparseablexml";
    public static final String PHASE_CONFIRMED = "confirmed";
    public static final String PHASE_IN_PROCESS = "in-process";
    public static final String PHASE_NEW = "new";
    public static final String PHASE_NONE = "none";
    public static final String PHASE_SCORED = "scored";
    public static final String PHASE_SUBMITTED = "submitted";
    public static final String SAVE_TYPE_AUTOSAVE = "autosave";
    public static final String SAVE_TYPE_FINALSAVE = "finalsave";
    public static final String SAVE_TYPE_INITIAL = "initial";
    public static final String SAVE_TYPE_NONE = "none";
    public static final String SAVE_TYPE_SCORE = "score";
    public static final DateFormat STANDARD_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");

    public boolean hasAutosave() {
        return this.lastSaveType.equals(SAVE_TYPE_AUTOSAVE) || this.lastSaveType.equals(SAVE_TYPE_FINALSAVE) || this.lastSaveType.equals(SAVE_TYPE_SCORE);
    }

    public boolean hasFinalsave() {
        return this.lastSaveType.equals(SAVE_TYPE_FINALSAVE) || this.lastSaveType.equals(SAVE_TYPE_SCORE);
    }

    public boolean hasScore() {
        return this.lastSaveType.equals(SAVE_TYPE_SCORE);
    }

    public boolean isConfirmed() {
        return this.phase.equals(PHASE_CONFIRMED);
    }

    public boolean isError() {
        return this.errorType != null;
    }

    public boolean isScored() {
        return this.phase.equals(PHASE_SCORED) || this.phase.equals(PHASE_CONFIRMED);
    }

    public boolean isSubmitted() {
        return this.phase.equals(PHASE_SUBMITTED) || this.phase.equals(PHASE_SCORED) || this.phase.equals(PHASE_CONFIRMED);
    }

    public boolean isUploadSuccessful() {
        return !this.isError() && this.httpReturnCode == 200;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String string) {
        this.errorType = string;
    }

    public Date getLastSaveDate() {
        return this.lastSaveDate;
    }

    public void setLastSaveDate(Date date) {
        this.lastSaveDate = date;
    }

    public long getLastSaveSize() {
        return this.lastSaveSize;
    }

    public void setLastSaveSize(long l) {
        this.lastSaveSize = l;
    }

    public String getLastSaveType() {
        return this.lastSaveType;
    }

    public void setLastSaveType(String string) {
        this.lastSaveType = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String string) {
        this.phase = string;
    }

    public int getHttpReturnCode() {
        return this.httpReturnCode;
    }

    public void setHttpReturnCode(int n) {
        this.httpReturnCode = n;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String string) {
        this.stackTrace = string;
    }

    public String toString() {
        return this.toXml();
    }

    public String toXml() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toXml(stringBuilder);
        return stringBuilder.toString();
    }

    public void toXml(StringBuilder stringBuilder) {
        stringBuilder.append("");
        stringBuilder.append("<state>\n");
        this.addField(stringBuilder, "source", this.source);
        this.addField(stringBuilder, "session", this.sessionId);
        this.addField(stringBuilder, "phase", this.phase);
        this.addField(stringBuilder, "last-save-type", this.lastSaveType);
        this.addField(stringBuilder, "last-save-date", this.lastSaveDate);
        this.addField(stringBuilder, "last-save-size", this.lastSaveSize, -1L);
        this.addField(stringBuilder, "action", this.action);
        this.addField(stringBuilder, "error-type", this.errorType);
        this.addField(stringBuilder, "http-return-code", this.httpReturnCode, -1);
        this.addField(stringBuilder, "message", this.message);
        this.addField(stringBuilder, "stack-trace", this.stackTrace);
        stringBuilder.append("</state>\n");
    }

    public void fromXml(Node node) {
        this.source = this.getField(node, "source", null);
        this.sessionId = this.getField(node, "session", null);
        this.phase = this.getField(node, "phase", PHASE_NEW);
        this.lastSaveType = this.getField(node, "last-save-type", SAVE_TYPE_INITIAL);
        this.lastSaveDate = this.getDateField(node, "last-save-date", null);
        this.lastSaveSize = this.getLongField(node, "last-save-size", -1L);
        this.action = this.getField(node, "action", null);
        this.errorType = this.getField(node, "error-type", null);
        this.httpReturnCode = this.getIntField(node, "http-return-code", -1);
        this.message = this.getField(node, "message", null);
        this.stackTrace = this.getField(node, "stack-trace", null);
    }

    protected void addField(StringBuilder stringBuilder, String string, Date date) {
        if (date != null) {
            this.addField(stringBuilder, string, STANDARD_DATE_FORMAT.format(date));
        }
    }

    protected void addField(StringBuilder stringBuilder, String string, int n, int n2) {
        if (n != n2) {
            this.addField(stringBuilder, string, String.valueOf(n));
        }
    }

    protected void addField(StringBuilder stringBuilder, String string, long l, long l2) {
        if (l != l2) {
            this.addField(stringBuilder, string, String.valueOf(l));
        }
    }

    protected void addField(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append("  <");
            stringBuilder.append(string);
            stringBuilder.append(">");
            stringBuilder.append(XMLUtils.escape(string2));
            stringBuilder.append("</");
            stringBuilder.append(string);
            stringBuilder.append(">\n");
        }
    }

    protected Date getDateField(Node node, String string, Date date) {
        String string2 = this.getField(node, string, null);
        if (string2 != null) {
            try {
                return STANDARD_DATE_FORMAT.parse(string2);
            }
            catch (Throwable throwable) {
                ErrorUtils.check(throwable);
            }
        }
        return date;
    }

    protected int getIntField(Node node, String string, int n) {
        String string2 = this.getField(node, string, null);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                ErrorUtils.check(throwable);
            }
        }
        return n;
    }

    protected long getLongField(Node node, String string, long l) {
        String string2 = this.getField(node, string, null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (Throwable throwable) {
                ErrorUtils.check(throwable);
            }
        }
        return l;
    }

    protected String getField(Node node, String string, String string2) {
        return XMLUtils2.getChildText(node, string, string2);
    }
}

