/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

public abstract class UniconThread
extends Thread {
    protected volatile boolean continueRunning = true;
    protected volatile long startTime;
    protected volatile long sleepTime = -1L;
    protected volatile long endTime = -1L;

    public UniconThread() {
        this.setDaemon(true);
    }

    public UniconThread(String string) {
        super(string);
        this.setDaemon(true);
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    protected void log(String string) {
    }

    public void end() {
        this.continueRunning = false;
        this.interrupt();
    }

    public void kill() {
        this.end();
    }

    public void setSleepTime(long l) {
        this.sleepTime = l;
    }

    public void setSleepTimeFromNow(long l) {
        this.sleepTime = l;
        this.endTime = l + System.currentTimeMillis();
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    protected void guaranteedSleep() {
        if (this.endTime > 0L) {
            this.guaranteedSleepUntil(this.endTime);
        } else {
            this.guaranteedSleepFor(this.sleepTime);
        }
    }

    protected void guaranteedSleepFor(long l) {
        block6: {
            try {
                long l2 = System.currentTimeMillis();
                long l3 = l2 + l;
                while (this.continueRunning && l3 >= l2) {
                    block5: {
                        try {
                            Thread.sleep(l3 - l2);
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.continueRunning) break block5;
                            return;
                        }
                    }
                    l2 = System.currentTimeMillis();
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)throwable;
            }
        }
    }

    protected void guaranteedSleepUntil(long l) {
        block6: {
            try {
                long l2 = System.currentTimeMillis();
                while (this.continueRunning && l >= l2) {
                    block5: {
                        try {
                            Thread.sleep(l - l2);
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.continueRunning) break block5;
                            return;
                        }
                    }
                    l2 = System.currentTimeMillis();
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)throwable;
            }
        }
    }
}

