/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import panther.util.unicon.MiniBag;

public class ThreadReporter {
    protected int createdCount = 0;
    protected MiniBag createdByThreadClass = new MiniBag();
    protected MiniBag createdByRunnableClass = new MiniBag();
    protected int activeCount = 0;
    protected long activeStackSize = 0L;
    protected MiniBag activeByThreadClass = new MiniBag();
    protected MiniBag activeByRunnableClass = new MiniBag();
    public static final ThreadReporter soleInstance = new ThreadReporter();

    public static ThreadReporter getInstance() {
        return soleInstance;
    }

    private ThreadReporter() {
    }

    public synchronized void registerCreation(Thread thread, boolean bl, Runnable runnable, ThreadGroup threadGroup, long l) {
        Class<?> clazz = thread.getClass();
        String string = runnable == null ? "Null" : runnable.getClass().getName();
        this.createdByThreadClass.add(clazz);
        this.createdByRunnableClass.add(string);
        this.activeByThreadClass.add(clazz);
        this.activeByRunnableClass.add(string);
        ++this.createdCount;
        ++this.activeCount;
        this.activeStackSize += l;
    }

    public synchronized void registerDestruction(Thread thread, boolean bl, Runnable runnable, ThreadGroup threadGroup, long l) {
        Class<?> clazz = thread.getClass();
        String string = runnable == null ? "Null" : runnable.getClass().getName();
        this.activeByThreadClass.remove(clazz);
        this.activeByRunnableClass.remove(string);
        --this.activeCount;
        this.activeStackSize -= l;
    }

    public void report(PrintStream printStream) {
        block6: {
            if (this.createdCount == 0) {
                return;
            }
            try {
                long l;
                long l2;
                Object object;
                StringBuffer stringBuffer = new StringBuffer("Report from ThreadReporter:");
                stringBuffer.append("\n\tcreatedCount = " + this.createdCount);
                stringBuffer.append("\n\tactiveCount = " + this.activeCount);
                stringBuffer.append("\n\tdestroyedCount = " + this.getDestroyedCount());
                stringBuffer.append("\n\tactiveStackSize = " + this.activeStackSize);
                List list = this.createdByThreadClass.getKeys();
                HashMap<String, Class> hashMap = new HashMap<String, Class>(list.size() * 3 / 2);
                for (int i = 0; i < list.size(); ++i) {
                    Class clazz = (Class)list.get(i);
                    hashMap.put(clazz.getName(), clazz);
                }
                ArrayList arrayList = new ArrayList(hashMap.keySet());
                Collections.sort(arrayList);
                stringBuffer.append("\n\tThreads by Thread Class");
                stringBuffer.append("\n\t  Total    Active   Thread Class");
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    object = (Class)hashMap.get(string);
                    l2 = this.activeByThreadClass.get(object);
                    l = this.createdByThreadClass.get(object);
                    stringBuffer.append("\n\t");
                    this.pad(stringBuffer, l, 8);
                    stringBuffer.append("    ");
                    this.pad(stringBuffer, l2, 5);
                    stringBuffer.append("   ");
                    stringBuffer.append(string);
                }
                List list2 = this.createdByRunnableClass.getKeys();
                Collections.sort(list2);
                stringBuffer.append("\n\tThreads by Runnable Class");
                stringBuffer.append("\n\t  Total    Active   Runnable Class");
                for (int i = 0; i < list2.size(); ++i) {
                    object = (String)list2.get(i);
                    l2 = this.activeByRunnableClass.get(object);
                    l = this.createdByRunnableClass.get(object);
                    stringBuffer.append("\n\t");
                    this.pad(stringBuffer, l, 8);
                    stringBuffer.append("    ");
                    this.pad(stringBuffer, l2, 5);
                    stringBuffer.append("   ");
                    stringBuffer.append((String)object);
                }
                printStream.println(stringBuffer.toString());
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)throwable;
            }
        }
    }

    protected void pad(StringBuffer stringBuffer, long l, int n) {
        String string = String.valueOf(l);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
    }

    public int getCreatedCount() {
        return this.createdCount;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public int getDestroyedCount() {
        return this.createdCount - this.activeCount;
    }

    public long getActiveStackSize() {
        return this.activeStackSize;
    }

    public Map getCreatedByThreadClass() {
        return this.createdByThreadClass.asMap();
    }

    public Map getCreatedByRunnableClass() {
        return this.createdByRunnableClass.asMap();
    }

    public Map getActiveByThreadClass() {
        return this.activeByThreadClass.asMap();
    }

    public Map getActiveByRunnableClass() {
        return this.activeByRunnableClass.asMap();
    }

    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < 5; ++i) {
            ThreadReporter.getInstance().report(System.out);
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

