/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationID;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import panther.util.general.DevOut;
import panther.util.resource.CachedResultSet;
import panther.util.resource.Resources;
import panther.util.unicon.DBUtil;
import panther.util.unicon.RMIService;

public abstract class RMIServiceImpl
extends Activatable
implements RMIService {
    protected static int threadCount = 1;

    public RMIServiceImpl(ActivationID activationID, MarshalledObject marshalledObject) throws RemoteException {
        super(activationID, 0);
        this.setStandardStreams();
    }

    public RMIServiceImpl(ActivationID activationID, int n) throws RemoteException {
        super(activationID, n);
        this.setStandardStreams();
    }

    protected abstract String getDbPoolName();

    public Map getAllocationInfo() throws RemoteException {
        return Resources.getAllocationInfo();
    }

    public String dumpThread(String string) throws RemoteException {
        Thread thread = this.findThread(string);
        if (thread == null) {
            return "no such thread as " + string;
        }
        return thread.toString() + "\n\tname = " + thread.getName() + "\n\tpriority = " + thread.getPriority() + "\n\talive = " + thread.isAlive() + "\n\tdaemon = " + thread.isDaemon() + "\n\tinterrupted = " + thread.isInterrupted();
    }

    public String dumpThreads() throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer(2048);
        Thread[] threadArray = this.getCurrentThreads();
        for (int i = 0; i < threadArray.length; ++i) {
            if (threadArray[i] == null) continue;
            stringBuffer.append(threadArray[i].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String killThread(String string) throws RemoteException {
        Thread thread = this.findThread(string);
        if (thread == null) {
            return "no such thread as " + string;
        }
        if (!thread.isAlive()) {
            return "already dead";
        }
        try {
            thread.destroy();
        }
        catch (Exception exception) {
            return "Unable to destroy Thread " + string + "\n" + this.formatStackTrace(exception);
        }
        return "destroyed";
    }

    protected Thread findThread(String string) {
        Thread[] threadArray = this.getCurrentThreads();
        for (int i = 0; i < threadArray.length; ++i) {
            if (threadArray[i] == null || !threadArray[i].getName().equalsIgnoreCase(string)) continue;
            return threadArray[i];
        }
        return null;
    }

    protected Thread[] getCurrentThreads() {
        int n = Thread.activeCount();
        Thread[] threadArray = new Thread[n * 2 + 20];
        Thread.enumerate(threadArray);
        return threadArray;
    }

    public synchronized String sleepThread(final long l) throws RemoteException {
        DevOut.println("Beginning sleepThread");
        Thread thread = new Thread("RMIServiceImplThread" + threadCount++){

            public void run() {
                DevOut.println("Beginning sleepThread thread");
                RMIServiceImpl.sleep(l);
                DevOut.println("Leaving sleepThread thread");
            }
        };
        thread.start();
        DevOut.println("Leaving sleepThread");
        return thread.getName();
    }

    public static void sleep(long l) {
        long l2 = System.currentTimeMillis() + l;
        do {
            long l3 = Math.max(0L, l2 - System.currentTimeMillis());
            try {
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (l2 > System.currentTimeMillis());
    }

    protected CachedResultSet executeCachedQuery(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet = preparedStatement.executeQuery();
        CachedResultSet cachedResultSet = new CachedResultSet(resultSet);
        this.safeClose(resultSet, preparedStatement);
        return cachedResultSet;
    }

    protected void safeClose(ResultSet resultSet, Statement statement) {
        DBUtil.safeClose(resultSet, statement);
    }

    protected void safeClose(ResultSet resultSet) {
        DBUtil.safeClose(resultSet);
    }

    protected void safeClose(Statement statement) {
        DBUtil.safeClose(statement);
    }

    protected String formatStackTrace(Exception exception) {
        String string = new String();
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        exception.printStackTrace(new PrintWriter(charArrayWriter));
        string = charArrayWriter.toString();
        charArrayWriter.close();
        return string;
    }

    public String getVMStats() throws RemoteException {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        long l2 = runtime.totalMemory();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Total Memory: " + l2 + " bytes\n");
        stringBuffer.append("Free Memory: " + l + " bytes\n");
        stringBuffer.append("In-user and non-recycled Memory: " + (l2 - l) + " bytes\n");
        return stringBuffer.toString();
    }

    protected void setStandardStreams() {
        this.setStandardStreams(System.getProperties());
    }

    protected void setStandardStreams(Properties properties) {
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        String string = null;
        try {
            string = properties.getProperty("stdout.filename");
            if (string != null) {
                System.setOut(new PrintStream(new FileOutputStream(string, true)));
            }
        }
        catch (Exception exception) {
            printStream.println("Invalid value for stdout.filename: " + string);
            System.setOut(printStream);
        }
        try {
            string = properties.getProperty("stderr.filename");
            if (string != null) {
                System.setErr(new PrintStream(new FileOutputStream(string, true)));
            }
        }
        catch (Exception exception) {
            printStream.println("Invalid value for stderr.filename: " + string);
            System.setErr(printStream2);
        }
    }
}

