/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import panther.util.general.OpsOut;

public class NodeToString {
    protected static ArrayList empty = new ArrayList();
    protected Node doc;
    protected HashMap stopTags;
    protected HashMap emptyTags;
    protected HashMap blankLineTags;
    protected int startIndent;
    protected int indent;
    protected int tabStop;
    protected Writer out;
    protected boolean canonical;
    protected boolean unwrapCDATA;
    protected boolean printTopLevelTag;
    protected boolean printNewLines;
    private static String[] MIME2JAVA_ENCODINGS = new String[]{"Default", "UTF-8", "US-ASCII", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-2022-JP", "SHIFT_JIS", "EUC-JP", "GB2312", "BIG5", "EUC-KR", "ISO-2022-KR", "KOI8-R", "EBCDIC-CP-US", "EBCDIC-CP-CA", "EBCDIC-CP-NL", "EBCDIC-CP-DK", "EBCDIC-CP-NO", "EBCDIC-CP-FI", "EBCDIC-CP-SE", "EBCDIC-CP-IT", "EBCDIC-CP-ES", "EBCDIC-CP-GB", "EBCDIC-CP-FR", "EBCDIC-CP-AR1", "EBCDIC-CP-HE", "EBCDIC-CP-CH", "EBCDIC-CP-ROECE", "EBCDIC-CP-YU", "EBCDIC-CP-IS", "EBCDIC-CP-AR2", "UTF-16"};

    public NodeToString(Node node, boolean bl) {
        this(node, empty, empty, empty, bl);
    }

    public NodeToString(Node node, List list, List list2, List list3, boolean bl) {
        this(node);
        this.printTopLevelTag = bl;
        this.printNewLines = true;
        this.setStopTags(list);
        this.setEmptyTags(list2);
        this.setBlankLineTags(list3);
    }

    public NodeToString(Node node) {
        this.doc = node;
        this.startIndent = 0;
        this.tabStop = 2;
        this.canonical = true;
        this.stopTags = new HashMap();
        this.emptyTags = new HashMap();
        this.blankLineTags = new HashMap();
        this.printTopLevelTag = true;
        this.printNewLines = true;
    }

    public void setWriter(Writer writer) {
        this.out = writer;
    }

    public void setIndent(int n) {
        this.startIndent = n;
    }

    public void setTabStop(int n) {
        this.tabStop = n;
    }

    public void setCanonical(boolean bl) {
        this.canonical = bl;
    }

    public void setPrintTopLevelTag(boolean bl) {
        this.printTopLevelTag = bl;
    }

    public void setPrintNewLines(boolean bl) {
        this.printNewLines = bl;
    }

    public void setUnwrapCDATA(boolean bl) {
        this.unwrapCDATA = bl;
    }

    public void setStopTags(List list) {
        this.stopTags = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            this.stopTags.put(list.get(i), "x");
        }
    }

    public void setEmptyTags(List list) {
        this.emptyTags = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            this.emptyTags.put(list.get(i), "x");
        }
    }

    public void setBlankLineTags(List list) {
        this.blankLineTags = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            this.blankLineTags.put(list.get(i), "x");
        }
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.indent = this.startIndent;
        try {
            this.out = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            this.print(this.doc, this.indent, this.tabStop, false, true);
        }
        catch (Exception exception) {
            OpsOut.trace(exception);
        }
        return byteArrayOutputStream.toString();
    }

    public void print(Node node, int n, int n2, boolean bl, boolean bl2) throws IOException {
        if (node == null) {
            return;
        }
        boolean bl3 = false;
        if (this.blankLineTags.get(node.getNodeName()) != null) {
            bl3 = true;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                if (!this.canonical && this.printTopLevelTag) {
                    this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                }
                this.print(((Document)node).getDocumentElement(), n, n2, bl, bl2);
                this.out.flush();
                break;
            }
            case 1: {
                int n3;
                int n4;
                int n5;
                NodeList nodeList = node.getChildNodes();
                for (n5 = 0; n5 < n; ++n5) {
                    this.out.write(32);
                }
                if (bl2 && this.printTopLevelTag || !bl2) {
                    this.out.write(60);
                    this.out.write(node.getNodeName());
                    Attr[] attrArray = this.sortAttributes(node.getAttributes());
                    for (n4 = 0; n4 < attrArray.length; ++n4) {
                        Attr attr = attrArray[n4];
                        this.out.write(32);
                        this.out.write(attr.getNodeName());
                        this.out.write("=\"");
                        this.out.write(this.normalize(attr.getNodeValue()));
                        this.out.write(34);
                    }
                }
                n5 = 0;
                if (nodeList.getLength() == 0 && this.emptyTags.get(node.getNodeName()) != null) {
                    if (bl2 && this.printTopLevelTag || !bl2) {
                        this.out.write(" />");
                    }
                    n5 = 1;
                } else if (bl2 && this.printTopLevelTag || !bl2) {
                    this.out.write(62);
                }
                if (n5 != 0) {
                    if (this.printNewLines) {
                        if (!bl) {
                            this.out.write(10);
                        }
                        if (bl3) {
                            this.out.write(10);
                        }
                    }
                    return;
                }
                n4 = 0;
                boolean bl4 = false;
                if (this.stopTags.get(node.getNodeName()) != null) {
                    n4 = 1;
                    bl4 = true;
                }
                if (nodeList != null) {
                    int n6;
                    n3 = nodeList.getLength();
                    for (n6 = 0; n6 < n3; ++n6) {
                        if (nodeList.item(n6).getNodeType() != 3) continue;
                        n4 = 1;
                    }
                    if (n4 == 0 && !bl) {
                        if (!bl4 && this.printNewLines) {
                            this.out.write(10);
                        }
                        for (n6 = 0; n6 < n3; ++n6) {
                            this.print(nodeList.item(n6), n + n2, n2, bl4, false);
                        }
                    } else {
                        for (n6 = 0; n6 < n3; ++n6) {
                            this.print(nodeList.item(n6), 0, 0, bl4 || bl, false);
                        }
                    }
                }
                if (n4 == 0 && !bl) {
                    for (n3 = 0; n3 < n; ++n3) {
                        this.out.write(32);
                    }
                }
                if (bl2 && this.printTopLevelTag || !bl2) {
                    this.out.write("</");
                    this.out.write(node.getNodeName());
                    this.out.write(">");
                    if (!bl && this.printNewLines) {
                        this.out.write(10);
                    }
                }
                if (!bl3 || !this.printNewLines) break;
                this.out.write(10);
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    int n7 = nodeList.getLength();
                    for (int i = 0; i < n7; ++i) {
                        this.print(nodeList.item(i), n, n2, bl, false);
                    }
                    break;
                }
                this.out.write(38);
                this.out.write(node.getNodeName());
                this.out.write(59);
                break;
            }
            case 4: {
                if (this.canonical || this.unwrapCDATA) {
                    this.out.write(this.normalize(node.getNodeValue()));
                    break;
                }
                this.out.write("<![CDATA[");
                this.out.write(node.getNodeValue());
                this.out.write("]]>");
                break;
            }
            case 3: {
                this.out.write(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.write("<?");
                this.out.write(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.out.write(32);
                    this.out.write(string);
                }
                this.out.write("?>");
                break;
            }
        }
        this.out.flush();
    }

    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = attrArray[n].getNodeName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = attrArray[i].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }

    protected String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

