/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import panther.util.smalltalk.SimpleBlock;
import panther.util.unicon.GuaranteedAction;

public abstract class GuaranteedActionImpl
implements GuaranteedAction {
    protected String name;
    protected long number;
    protected Object returnValue;
    protected boolean successful = false;
    protected Throwable throwable;
    protected boolean interrupted = false;
    protected boolean timedOut = false;
    protected boolean resolved = false;
    protected long timeLimit;
    protected long creationTime = System.currentTimeMillis();
    protected long runStartTime;
    protected long resolutionStartTime;
    protected long resolutionEndTime;
    protected long endTime;
    protected static long actionCount = 1L;

    public GuaranteedActionImpl(String string, long l, SimpleBlock simpleBlock) {
        this.name = string;
        this.number = GuaranteedActionImpl.nextNumber();
        this.timeLimit = l;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public boolean erroredOut() {
        return this.throwable != null;
    }

    public boolean interrupted() {
        return this.interrupted;
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    public String toString() {
        return "GuaranteedAction " + this.number;
    }

    public synchronized void run() {
        block3: {
            this.runStartTime = System.currentTimeMillis();
            this.startThreads();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
            }
            catch (Throwable throwable) {
                this.error(throwable);
                if (!(throwable instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)throwable;
            }
        }
        this.endTime = System.currentTimeMillis();
    }

    protected synchronized void interrupt() {
        if (!this.resolved) {
            this.resolutionStartTime = System.currentTimeMillis();
            this.resolved = true;
            this.interrupted = true;
            this.timedOut = false;
            this.successful = false;
            this.terminateForInterrupt();
            this.resolutionEndTime = System.currentTimeMillis();
            this.notify();
        }
    }

    protected synchronized void timeout() {
        if (!this.resolved) {
            this.resolutionStartTime = System.currentTimeMillis();
            this.resolved = true;
            this.interrupted = false;
            this.timedOut = true;
            this.successful = false;
            this.terminateForTimeout();
            this.resolutionEndTime = System.currentTimeMillis();
            this.notify();
        }
    }

    public synchronized void error(Throwable throwable) {
        if (!this.resolved) {
            this.resolutionStartTime = System.currentTimeMillis();
            this.resolved = true;
            this.throwable = throwable;
            this.interrupted = false;
            this.timedOut = false;
            this.successful = false;
            this.terminateForError();
            this.resolutionEndTime = System.currentTimeMillis();
            this.notify();
        }
    }

    public synchronized void finished(Object object) {
        if (!this.resolved) {
            this.resolutionStartTime = System.currentTimeMillis();
            this.resolved = true;
            this.returnValue = object;
            this.interrupted = false;
            this.timedOut = false;
            this.successful = true;
            this.terminateForFinished();
            this.resolutionEndTime = System.currentTimeMillis();
            this.notify();
        }
    }

    protected abstract void startThreads();

    protected abstract void terminateForError();

    protected abstract void terminateForFinished();

    protected abstract void terminateForInterrupt();

    protected abstract void terminateForTimeout();

    protected static synchronized long nextNumber() {
        return actionCount++;
    }
}

