/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import panther.util.general.UserOut;
import panther.util.unicon.Base64Decode;
import panther.util.unicon.Base64Encode;
import panther.util.unicon.RootException;

public class Crypt {
    private static final int SHIFTINDEX = 5;
    private static final String DELIMETER = ",";
    private static final byte USER_INFO_XOR_CRYPT = 36;

    public static int encrypt(int n) {
        BigInteger bigInteger = new BigInteger("" + n);
        return Integer.parseInt(bigInteger.shiftLeft(5).toString());
    }

    public static String encrypt(String string) {
        if (string == null) {
            return null;
        }
        BigInteger bigInteger = new BigInteger(string);
        return bigInteger.shiftLeft(5).toString();
    }

    public static int decrypt(int n) {
        BigInteger bigInteger = new BigInteger("" + n);
        return Integer.parseInt(bigInteger.shiftRight(5).toString());
    }

    public static String decrypt(String string) {
        if (string == null) {
            return null;
        }
        BigInteger bigInteger = new BigInteger(string);
        return bigInteger.shiftRight(5).toString();
    }

    public static String encryptUserInfo(String[] stringArray) throws RootException {
        if (stringArray == null || stringArray.length == 0) {
            throw new RootException("User Information must be set.");
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(DELIMETER);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        byte[] byArray = stringBuffer.toString().getBytes();
        byArray = new Base64Encode().encodeBytes(byArray);
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)(byArray[i] ^ 0x24);
        }
        return new String(cArray);
    }

    public static String encryptUserInfo(String string, String string2) throws RootException {
        if (string == null || string2 == null) {
            throw new RootException("Username and Password must not be null.");
        }
        String[] stringArray = new String[]{string, string2};
        return Crypt.encryptUserInfo(stringArray);
    }

    public static String[] decryptUserInfo(String string) throws RootException {
        if (string == null) {
            throw new RootException("Encrypted text must not be null.");
        }
        Object var1_1 = null;
        Object var2_2 = null;
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)((byte)cArray[i] ^ 0x24);
        }
        byArray = new Base64Decode().decodeBytes(byArray);
        String string2 = new String(byArray);
        ArrayList<String> arrayList = new ArrayList<String>(3);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, DELIMETER);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        String[] stringArray2 = new String[]{"Bob", "bob23", "12345"};
        for (n = 0; n < stringArray2.length; ++n) {
            if (stringArray.length < stringArray2.length) continue;
            stringArray2[n] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            UserOut.println("UnCrypted[" + n + "] = \"" + stringArray2[n] + "\"");
        }
        String string = Crypt.encryptUserInfo(stringArray2);
        UserOut.println("Encrypted String: \"" + URLEncoder.encode(string) + "\"");
        String[] stringArray3 = Crypt.decryptUserInfo(string);
        for (int i = 0; i < stringArray3.length; ++i) {
            UserOut.println("DeCrypted[" + i + "] = \"" + stringArray3[i] + "\"");
        }
        String string2 = "Jane";
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        String string3 = "secret";
        if (stringArray.length > 1) {
            string3 = stringArray[1];
        }
        UserOut.println("UnCrypted username: \"" + string2 + "\"");
        UserOut.println("UnCrypted password: \"" + string3 + "\"");
        String string4 = Crypt.encryptUserInfo(string2, string3);
        UserOut.println("Encrypted String: \"" + URLEncoder.encode(string4) + "\"");
        String[] stringArray4 = Crypt.decryptUserInfo(string4);
        UserOut.println("UnCrypted username: \"" + stringArray4[0] + "\"");
        UserOut.println("UnCrypted password: \"" + stringArray4[1] + "\"");
    }
}

