/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import panther.util.resource.ResourceLogConfig;

public abstract class ResourcePoolConfiguration {
    protected int allocationWaitWarnTime = 60000;
    protected int allocationWarnTime = 60000;
    protected int createLimit = 10000;
    protected int creationWarnTime = 60000;
    protected int destroyLimit = 20000;
    protected int destroyThreadRecycleTime = 300000;
    protected ResourceLogConfig logConfig = ResourceLogConfig.DEFAULT_LOG_CONFIG;
    protected int loginTimeout = 0;
    protected int maxAllocationWaitTime = 60000;
    protected int maxSize = 10;
    protected int maxUsageCount = 100;
    protected int minSize = 10;
    protected String name = "pool";
    protected int numberOfRecycleThreads = 1;
    protected int recycleLimit = 10000;
    protected int recycleWarnTime = 60000;
    protected int sizeSleepTime = 60000;
    protected int timeoutPeriod = 60000;
    protected int timeoutSleepTime = 60000;
    protected int traceCallers = 0;
    protected boolean useDeadlockAvoidance = true;
    protected boolean useGuaranteedActions = true;
    protected boolean useRecycleQueue = true;
    protected int verifyLimit = 5000;

    public ResourcePoolConfiguration(String string) {
        this.name = string;
    }

    public abstract String getDescriptor();

    public int getAllocationWaitWarnTime() {
        return this.allocationWaitWarnTime;
    }

    public void setAllocationWaitWarnTime(int n) {
        this.allocationWaitWarnTime = n;
    }

    public int getAllocationWarnTime() {
        return this.allocationWarnTime;
    }

    public void setAllocationWarnTime(int n) {
        this.allocationWarnTime = n;
    }

    public int getCreateLimit() {
        return this.createLimit;
    }

    public void setCreateLimit(int n) {
        this.createLimit = n;
    }

    public int getCreationWarnTime() {
        return this.creationWarnTime;
    }

    public void setCreationWarnTime(int n) {
        this.creationWarnTime = n;
    }

    public int getDestroyLimit() {
        return this.destroyLimit;
    }

    public void setDestroyLimit(int n) {
        this.destroyLimit = n;
    }

    public int getDestroyThreadRecycleTime() {
        return this.destroyThreadRecycleTime;
    }

    public void setDestroyThreadRecycleTime(int n) {
        this.destroyThreadRecycleTime = n;
    }

    public ResourceLogConfig getLogConfig() {
        return this.logConfig;
    }

    public void setLogConfig(ResourceLogConfig resourceLogConfig) {
        this.logConfig = resourceLogConfig;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public int getMaxAllocationWaitTime() {
        return this.maxAllocationWaitTime;
    }

    public void setMaxAllocationWaitTime(int n) {
        this.maxAllocationWaitTime = n;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        if (this.minSize > n) {
            this.minSize = n;
        }
        this.maxSize = n;
    }

    public int getMaxUsageCount() {
        return this.maxUsageCount;
    }

    public void setMaxUsageCount(int n) {
        this.maxUsageCount = n;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int n) {
        if (this.maxSize < n) {
            this.maxSize = n;
        }
        this.minSize = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getNumberOfRecycleThreads() {
        return this.numberOfRecycleThreads;
    }

    public void setNumberOfRecycleThreads(int n) {
        this.numberOfRecycleThreads = n;
    }

    public int getRecycleLimit() {
        return this.recycleLimit;
    }

    public void setRecycleLimit(int n) {
        this.recycleLimit = n;
    }

    public int getRecycleWarnTime() {
        return this.recycleWarnTime;
    }

    public void setRecycleWarnTime(int n) {
        this.recycleWarnTime = n;
    }

    public void setSize(int n) {
        this.maxSize = n;
        this.minSize = n;
    }

    public int getSizeSleepTime() {
        return this.sizeSleepTime;
    }

    public void setSizeSleepTime(int n) {
        this.sizeSleepTime = n;
    }

    public int getTimeoutPeriod() {
        return this.timeoutPeriod;
    }

    public void setTimeoutPeriod(int n) {
        this.timeoutPeriod = n;
    }

    public int getTimeoutSleepTime() {
        return this.timeoutSleepTime;
    }

    public void setTimeoutSleepTime(int n) {
        this.timeoutSleepTime = n;
    }

    public int getTraceCallers() {
        return this.traceCallers;
    }

    public void setTraceCallers(int n) {
        this.traceCallers = n;
    }

    public int getVerifyLimit() {
        return this.verifyLimit;
    }

    public void setVerifyLimit(int n) {
        this.verifyLimit = n;
    }

    public boolean isValid() {
        return true;
    }

    public boolean useDeadlockAvoidance() {
        return this.useDeadlockAvoidance;
    }

    public void setUseDeadlockAvoidance(boolean bl) {
        this.useDeadlockAvoidance = bl;
    }

    public boolean useGuaranteedActions() {
        return this.useGuaranteedActions;
    }

    public void setUseGuaranteedActions(boolean bl) {
        this.useGuaranteedActions = bl;
    }

    public boolean useRecycleQueue() {
        return this.useRecycleQueue;
    }

    public void setUseRecycleQueue(boolean bl) {
        this.useRecycleQueue = bl;
    }

    public String toString() {
        return "\tallocationWaitWarnTime = " + this.allocationWaitWarnTime + "\n\tallocationWarnTime = " + this.allocationWarnTime + "\n\tcreateLimit = " + this.createLimit + "\n\tcreationWarnTime = " + this.creationWarnTime + "\n\tdestroyLimit = " + this.destroyLimit + "\n\tdestroyThreadRecycleTime = " + this.destroyThreadRecycleTime + "\n\tloginTimeout = " + this.loginTimeout + "\n\tmaxAllocationWaitTime = " + this.maxAllocationWaitTime + "\n\tmaxSize = " + this.maxSize + "\n\tmaxUsageCount = " + this.maxUsageCount + "\n\tminSize = " + this.minSize + "\n\tname = " + this.name + "\n\tnumberOfRecycleThreads = " + this.numberOfRecycleThreads + "\n\trecycleLimit = " + this.recycleLimit + "\n\trecycleWarnTime = " + this.recycleWarnTime + "\n\tsizeSleepTime = " + this.sizeSleepTime + "\n\ttimeoutPeriod = " + this.timeoutPeriod + "\n\ttimeoutSleepTime = " + this.timeoutSleepTime + "\n\ttraceCallers = " + this.traceCallers + "\n\tuseDeadlockAvoidance = " + this.useDeadlockAvoidance + "\n\tuseGuaranteedActions = " + this.useGuaranteedActions + "\n\tuseRecycleQueue = " + this.useRecycleQueue + "\n\tverifyLimit = " + this.verifyLimit;
    }
}

