/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import panther.util.general.OpsOut;
import panther.util.resource.ConnectionPoolConfiguration;
import panther.util.resource.ConnectionResource;
import panther.util.resource.ConnectionWrapper;
import panther.util.resource.Resource;
import panther.util.resource.ResourceFactory;
import panther.util.resource.ResourcePool;

public class ConnectionFactory
implements ResourceFactory {
    protected String driver;
    protected int loginTimeout = 0;
    protected String password;
    protected String simpleSQL;
    protected int transactionIsolation = -1;
    protected String url;
    protected String user;
    protected boolean useWrapper;
    protected static volatile int connectionCount = 1;

    public ConnectionFactory() {
        this.useWrapper = true;
    }

    public ConnectionFactory(ConnectionPoolConfiguration connectionPoolConfiguration) {
        this.url = connectionPoolConfiguration.getUrl();
        this.user = connectionPoolConfiguration.getUser();
        this.password = connectionPoolConfiguration.getPassword();
        this.simpleSQL = connectionPoolConfiguration.getSimpleSQL();
        this.transactionIsolation = connectionPoolConfiguration.getTransactionIsolation();
        this.useWrapper = connectionPoolConfiguration.useWrapper();
    }

    public Resource createEmptyResource(ResourcePool resourcePool, String string) {
        return new ConnectionResource(resourcePool, string, null, null, this.simpleSQL);
    }

    public Resource createResource(ResourcePool resourcePool, String string) {
        Object object = this.createRawResource();
        long l = -1L;
        if (object != null) {
            l = ConnectionFactory.nextNumber();
        }
        return new ConnectionResource(resourcePool, string, new Long(l), object, this.simpleSQL);
    }

    public Resource createResource(ResourcePool resourcePool, String string, Resource resource) {
        return new ConnectionResource(resourcePool, string, resource.getRawResourceID(), resource.getRawResource(), this.simpleSQL);
    }

    public String getDriver() {
        return this.driver;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSimpleSQL() {
        return this.simpleSQL;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isUseWrapper() {
        return this.useWrapper;
    }

    public Resource recreateResource(ResourcePool resourcePool, Resource resource) {
        Resource resource2 = this.createResource(resourcePool, resource.getRequester(), resource);
        resource2.copyFrom(resource);
        return resource2;
    }

    public void setDriver(String string) {
        try {
            Class.forName(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.driver = string;
    }

    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
        DriverManager.setLoginTimeout(n);
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setSimpleSQL(String string) {
        this.simpleSQL = string;
    }

    public void setTransactionIsolation(int n) {
        this.transactionIsolation = n;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setUseWrapper(boolean bl) {
        this.useWrapper = bl;
    }

    protected Object createRawResource() {
        return this.getConnection(this.user, this.password);
    }

    protected Connection getConnection(String string, String string2) {
        try {
            Connection connection = DriverManager.getConnection(this.url, string, string2);
            if (this.useWrapper) {
                connection = new ConnectionWrapper(connection, this.url, string, string2);
            }
            this.setConnectionTransactionIsolation(connection);
            connection.setAutoCommit(false);
            return connection;
        }
        catch (Exception exception) {
            OpsOut.trace(exception);
            return null;
        }
    }

    protected void setConnectionTransactionIsolation(Connection connection) throws Exception {
        int n;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (databaseMetaData.supportsTransactions() && (n = this.findClosestAvailableTransactionIsolation(databaseMetaData, this.transactionIsolation)) > 0) {
            connection.setTransactionIsolation(n);
        }
    }

    protected int findClosestAvailableTransactionIsolation(DatabaseMetaData databaseMetaData, int n) throws Exception {
        if (databaseMetaData.supportsTransactionIsolationLevel(n)) {
            return n;
        }
        int n2 = this.findClosestHigherTransactionIsolation(databaseMetaData, n);
        if (n2 > 0) {
            return n2;
        }
        int n3 = this.findClosestLowerTransactionIsolation(databaseMetaData, n);
        if (n3 > 0) {
            return n3;
        }
        return -1;
    }

    protected int findClosestHigherTransactionIsolation(DatabaseMetaData databaseMetaData, int n) throws Exception {
        if (0 > n && databaseMetaData.supportsTransactionIsolationLevel(0)) {
            return 0;
        }
        if (1 > n && databaseMetaData.supportsTransactionIsolationLevel(1)) {
            return 1;
        }
        if (2 > n && databaseMetaData.supportsTransactionIsolationLevel(2)) {
            return 2;
        }
        if (4 > n && databaseMetaData.supportsTransactionIsolationLevel(4)) {
            return 4;
        }
        if (8 > n && databaseMetaData.supportsTransactionIsolationLevel(8)) {
            return 8;
        }
        return -1;
    }

    protected int findClosestLowerTransactionIsolation(DatabaseMetaData databaseMetaData, int n) throws Exception {
        if (8 < n && databaseMetaData.supportsTransactionIsolationLevel(8)) {
            return 8;
        }
        if (4 < n && databaseMetaData.supportsTransactionIsolationLevel(4)) {
            return 4;
        }
        if (2 < n && databaseMetaData.supportsTransactionIsolationLevel(2)) {
            return 2;
        }
        if (1 < n && databaseMetaData.supportsTransactionIsolationLevel(1)) {
            return 1;
        }
        if (0 < n && databaseMetaData.supportsTransactionIsolationLevel(0)) {
            return 0;
        }
        return -1;
    }

    public static synchronized int getConnectionCount() {
        return connectionCount - 1;
    }

    protected static synchronized int nextNumber() {
        return connectionCount++;
    }
}

