/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import panther.util.general.OpsOut;
import panther.util.resource.ConnectionWrapper;
import panther.util.resource.DbParameter;
import panther.util.resource.PreparedStatementWrapper;
import panther.util.resource.ResultSetWrapper;

public class CallableStatementWrapper
extends PreparedStatementWrapper
implements CallableStatement {
    public static final int REG_OUT01 = 1;
    public static final int REG_OUT02 = 2;
    public static final int REG_OUT03 = 3;
    protected ArrayList outParameters = new ArrayList();
    public static final String notImplemented = "This method is not implemented in the CachedResultSet";

    public CallableStatementWrapper(CallableStatement callableStatement, ConnectionWrapper connectionWrapper, String string) {
        super(callableStatement, connectionWrapper, string);
    }

    public void recreateCallable() {
        int n = 0;
        try {
            this.stmt = this.sql == null ? this.conn.recreateStatement() : this.conn.recreateCallable(this.sql);
            this.rebuildInParameters();
            n = this.outParameters.size();
            block7: for (int i = 0; i < n; ++i) {
                DbParameter dbParameter = (DbParameter)this.outParameters.get(i);
                switch (dbParameter.getFunction()) {
                    case 1: {
                        this.registerOutParameter(dbParameter.getIndex(), (int)((Integer)dbParameter.getObject()));
                        continue block7;
                    }
                    case 2: {
                        this.registerOutParameter(dbParameter.getIndex(), (int)((Integer)dbParameter.getObject()), dbParameter.getLength());
                        continue block7;
                    }
                    case 3: {
                        this.registerOutParameter(dbParameter.getIndex(), (int)((Integer)dbParameter.getObject()), dbParameter.getTypeName());
                        continue block7;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private String getOracleSqlString() {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        DbParameter dbParameter = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer = stringBuffer.append("Oracle SQL syntax:\n");
        n3 = this.sql.indexOf("?", n2);
        while (n3 > 0 && this.validParameter(n3)) {
            dbParameter = this.atInParameter(n);
            if (dbParameter == null) {
                dbParameter = this.atOutParameter(n);
                if (dbParameter == null) {
                    OpsOut.println("ERROR: No parameter with index " + n + " found!");
                } else {
                    stringBuffer.append("VAR out" + n + " " + this.getOracleVarType(dbParameter) + " \n");
                    stringBuffer2.append(this.sql.substring(n2, n3) + ":out" + n);
                    ++n;
                }
            } else {
                stringBuffer2.append(this.sql.substring(n2, n3));
                stringBuffer2.append(this.getInParameterValue(dbParameter));
                ++n;
            }
            n4 = n3;
            n2 = n3 + 1;
            n3 = this.sql.indexOf("?", n2);
        }
        stringBuffer2.append(this.sql.substring(n4 + 1, this.sql.length()));
        return stringBuffer.toString() + stringBuffer2.toString();
    }

    private DbParameter atOutParameter(int n) {
        for (int i = 0; i < this.outParameters.size(); ++i) {
            DbParameter dbParameter = (DbParameter)this.outParameters.get(i);
            if (dbParameter.getIndex() != n) continue;
            return dbParameter;
        }
        return null;
    }

    private String getOracleVarType(DbParameter dbParameter) {
        int n = 0;
        if (dbParameter.getTypeName() != null) {
            return dbParameter.getTypeName();
        }
        n = (Integer)dbParameter.getObject();
        return this.convertJDBCtoOracleType(n);
    }

    private String convertJDBCtoOracleType(int n) {
        if (n == 2 || n == 3 || n == -6 || n == 5 || n == 4 || n == -5 || n == 7 || n == 6 || n == 8) {
            return "NUMBER";
        }
        if (n == 1) {
            return "CHAR";
        }
        if (n == 12) {
            return "VARCHAR2(255)";
        }
        if (n == 91 || n == 92 || n == 93) {
            return "DATE";
        }
        if (n == 2006) {
            return "REFCURSOR";
        }
        if (n == -1) {
            return "LONG";
        }
        if (n == -3) {
            return "RAW";
        }
        if (n == -4) {
            return "LONG RAW";
        }
        if (n == 2004) {
            return "BLOB";
        }
        if (n == 2005) {
            return "CLOB";
        }
        if (n == 1111) {
            return "<OTHER = ?>";
        }
        return "<UNABLE TO RESOLVE JDBC TYPE >" + n + "< TO ORACLE DATA TYPE>";
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.outParameters.add(new DbParameter(n, new Integer(n2), 0, 0, 1, null, null));
        ((CallableStatement)this.stmt).registerOutParameter(n, n2);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.outParameters.add(new DbParameter(n, new Integer(n2), n3, 0, 2, null, null));
        ((CallableStatement)this.stmt).registerOutParameter(n, n2, n3);
    }

    public boolean wasNull() throws SQLException {
        return ((CallableStatement)this.stmt).wasNull();
    }

    public String getString(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getString(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getBoolean(n);
    }

    public byte getByte(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getByte(n);
    }

    public short getShort(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getShort(n);
    }

    public int getInt(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getInt(n);
    }

    public long getLong(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getLong(n);
    }

    public float getFloat(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getFloat(n);
    }

    public double getDouble(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getDouble(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return ((CallableStatement)this.stmt).getBigDecimal(n, n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getBytes(n);
    }

    public Date getDate(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getDate(n);
    }

    public Time getTime(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getTimestamp(n);
    }

    public Object getObject(int n) throws SQLException {
        Object object = ((CallableStatement)this.stmt).getObject(n);
        if (object instanceof ResultSet) {
            ResultSetWrapper resultSetWrapper = new ResultSetWrapper((ResultSet)object, this);
            this.resultSets.add(resultSetWrapper);
            return resultSetWrapper;
        }
        return object;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getBigDecimal(n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        Object object = ((CallableStatement)this.stmt).getObject(n, map);
        if (object instanceof ResultSet) {
            ResultSetWrapper resultSetWrapper = new ResultSetWrapper((ResultSet)object, this);
            this.resultSets.add(resultSetWrapper);
            return resultSetWrapper;
        }
        return object;
    }

    public Ref getRef(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getRef(n);
    }

    public Blob getBlob(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getBlob(n);
    }

    public Clob getClob(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getClob(n);
    }

    public Array getArray(int n) throws SQLException {
        return ((CallableStatement)this.stmt).getArray(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return ((CallableStatement)this.stmt).getDate(n, calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return ((CallableStatement)this.stmt).getTime(n, calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return ((CallableStatement)this.stmt).getTimestamp(n, calendar);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.outParameters.add(new DbParameter(n, new Integer(n2), 0, 0, 3, null, string));
        ((CallableStatement)this.stmt).registerOutParameter(n, n2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        int n = 0;
        try {
            boolean bl = ((PreparedStatement)this.stmt).execute();
            return bl;
        }
        catch (SQLException sQLException) {
            n = sQLException.getErrorCode();
            OpsOut.println("SQL Error code: " + n);
            if (n == 4068) {
                this.conn.resetConnection();
                this.recreateCallable();
                boolean bl = ((PreparedStatement)this.stmt).execute();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.outParameters.clear();
        }
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public URL getURL(int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setNull(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setByte(String string, byte by) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setShort(String string, short s) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setInt(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setLong(String string, long l) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setFloat(String string, float f) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setDouble(String string, double d) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setDate(String string, Date date) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setTime(String string, Time time) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setObject(String string, Object object) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public String getString(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public boolean getBoolean(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public byte getByte(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public short getShort(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public int getInt(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public long getLong(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public float getFloat(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public double getDouble(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public byte[] getBytes(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Date getDate(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Time getTime(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Object getObject(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Ref getRef(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Blob getBlob(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Clob getClob(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Array getArray(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public URL getURL(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }
}

