/*
 * Decompiled with CFR 0.152.
 */
package panther.util.net;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import panther.util.general.ByteArrayUtils;
import panther.util.general.IOUtils;
import panther.util.net.MimeContent;

public class MimeEntry {
    protected int entryNumber;
    protected String name;
    protected String contentType;
    protected String filename;
    protected byte[] rawContent;
    protected String textContent;

    public MimeEntry(int n) {
        this.entryNumber = n;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.toString(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    public void toString(PrintWriter printWriter) {
        printWriter.println("MimeEntry " + this.name);
        printWriter.println("\tcontentType = " + this.contentType);
        printWriter.println("\tfilename = " + this.filename);
        printWriter.println("\trawContent.length = " + this.rawContent.length);
        if (this.isText()) {
            printWriter.println("\ttextContent.length() = " + this.textContent.length());
        }
    }

    public int getEntryNumber() {
        return this.entryNumber;
    }

    public void setEntryNumber(int n) {
        this.entryNumber = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public byte[] getRawContent() {
        return this.rawContent;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String string) throws Exception {
        if (!this.isText()) {
            throw new Error("MimeEntry contentType [" + this.contentType + "] not consistent with text");
        }
        this.textContent = string;
        this.rawContent = this.convertToBytes(string);
    }

    public void setContent(String string, byte[] byArray) throws Exception {
        this.contentType = string;
        this.rawContent = byArray;
        this.textContent = this.isText() ? this.convert(string, byArray) : null;
    }

    public boolean isText() {
        return this.contentType == null || this.contentType.startsWith("text");
    }

    protected String convert(String string, byte[] byArray) throws Exception {
        return new String(byArray, "utf-8");
    }

    protected byte[] convertToBytes(String string) throws Exception {
        return string.getBytes("utf-8");
    }

    public void write(OutputStream outputStream) throws Exception {
        outputStream.write(MimeContent.END);
        this.writeContentDisposition(outputStream);
        if (this.contentType != null) {
            outputStream.write(MimeContent.END);
            this.writeContentType(outputStream);
        }
        outputStream.write(MimeContent.END_END);
        outputStream.write(this.rawContent);
        outputStream.write(MimeContent.END);
    }

    protected void writeContentDisposition(OutputStream outputStream) throws Exception {
        String string = "Content-Disposition: form-data; name=\"" + this.name + "\"";
        if (this.filename != null) {
            string = string + "; filename=\"" + this.filename + "\"";
        }
        outputStream.write(string.getBytes("utf-8"));
    }

    protected void writeContentType(OutputStream outputStream) throws Exception {
        String string = "Content-Type: " + this.contentType;
        outputStream.write(string.getBytes("utf-8"));
    }

    public void parse(InputStream inputStream) throws Exception {
        byte[] byArray = IOUtils.readBytes(inputStream);
        byArray = ByteArrayUtils.removeStart(byArray, MimeContent.END);
        byArray = ByteArrayUtils.removeEnd(byArray, MimeContent.END);
        int n = ByteArrayUtils.indexOf(byArray, MimeContent.END_END);
        byte[] byArray2 = ByteArrayUtils.copyOfRange(byArray, 0, n);
        this.rawContent = ByteArrayUtils.subarray(byArray, n + MimeContent.END_END.length, byArray.length);
        List<ByteArrayInputStream> list = ByteArrayUtils.split(byArray2, MimeContent.END);
        for (ByteArrayInputStream byteArrayInputStream : list) {
            byte[] byArray3 = new byte[byteArrayInputStream.available()];
            byteArrayInputStream.read(byArray3, 0, byteArrayInputStream.available());
            this.parseHeader(new String(byArray3, "utf-8"));
        }
        if (this.isText()) {
            this.textContent = this.convert(this.contentType, this.rawContent);
        }
    }

    protected void parseHeader(String string) throws Exception {
        String string2 = ": ";
        int n = string.indexOf(string2);
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + string2.length());
        if (string3.equals("Content-Disposition")) {
            string2 = " name=\"";
            n = string4.indexOf(string2);
            int n2 = string4.indexOf("\"", n + string2.length());
            this.name = string4.substring(n + string2.length(), n2);
            string2 = "filename=\"";
            n = string4.indexOf(string2);
            if (n >= 0) {
                n2 = string4.indexOf("\"", n + string2.length());
                this.filename = string4.substring(n + string2.length(), n2);
            }
        } else if (string3.equals("Content-Type")) {
            this.setContentType(string4);
        }
    }
}

