/*
 * Decompiled with CFR 0.152.
 */
package panther.util.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import panther.util.general.ByteArrayUtils;
import panther.util.general.ErrorUtils;
import panther.util.general.IOUtils;
import panther.util.net.MimeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeContent {
    protected List<MimeEntry> entries = new ArrayList<MimeEntry>();
    public static byte[] END = new byte[]{13, 10};
    public static byte[] END_END = new byte[]{13, 10, 13, 10};
    public static byte[] INTRO = new byte[]{45, 45};

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.toString(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    public void toString(PrintWriter printWriter) {
        printWriter.println("MimeContent with " + this.entries.size() + " entries");
        for (MimeEntry mimeEntry : this.entries) {
            printWriter.println("---------------------------------------------");
            mimeEntry.toString(printWriter);
        }
        printWriter.println("---------------------------------------------");
    }

    public List<MimeEntry> getEntries() {
        return this.entries;
    }

    public MimeEntry getEntry(String string) {
        for (MimeEntry mimeEntry : this.entries) {
            if (!mimeEntry.getName().equals(string)) continue;
            return mimeEntry;
        }
        return null;
    }

    public void addEntry(MimeEntry mimeEntry) {
        mimeEntry.setEntryNumber(this.entries.size() + 1);
        this.entries.add(mimeEntry);
    }

    public void write(byte[] byArray, OutputStream outputStream) throws Exception {
        byte[] byArray2 = ByteArrayUtils.combine(INTRO, byArray);
        byte[] byArray3 = ByteArrayUtils.combine(INTRO, byArray);
        byte[] byArray4 = ByteArrayUtils.combine(INTRO, END);
        outputStream.write(byArray2);
        for (MimeEntry mimeEntry : this.entries) {
            mimeEntry.write(outputStream);
            outputStream.write(byArray3);
        }
        outputStream.write(byArray4);
    }

    public void parse(byte[] byArray, InputStream inputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byte[] byArray3 = ByteArrayUtils.combine(INTRO, byArray);
        byte[] byArray4 = ByteArrayUtils.combine(INTRO, byArray);
        byte[] byArray5 = ByteArrayUtils.combine(INTRO, byArray, INTRO, END);
        if (!ByteArrayUtils.startsWith(byArray2, byArray3)) {
            throw new Error(this.getMimeContentBeginErrorMessage(byArray2, byArray3));
        }
        if (!ByteArrayUtils.endsWith(byArray2, byArray5)) {
            throw new Error(this.getMimeContentEndErrorMessage(byArray2, byArray5));
        }
        byArray2 = ByteArrayUtils.removeStart(byArray2, byArray3);
        byArray2 = ByteArrayUtils.removeEnd(byArray2, byArray5);
        List<ByteArrayInputStream> list = ByteArrayUtils.split(byArray2, byArray4);
        this.entries = new ArrayList<MimeEntry>();
        for (ByteArrayInputStream byteArrayInputStream : list) {
            MimeEntry mimeEntry = new MimeEntry(this.entries.size() + 1);
            mimeEntry.parse(byteArrayInputStream);
            this.entries.add(mimeEntry);
        }
    }

    public static String getContentType(byte[] byArray) throws Exception {
        return "multipart/form-data; boundary=" + new String(byArray, "utf-8");
    }

    public static byte[] generateSeparator() {
        int n;
        Random random = new Random();
        byte[] byArray = new byte[54];
        for (n = 0; n < 27; ++n) {
            byArray[n] = 45;
        }
        for (n = 27; n < 54; ++n) {
            byArray[n] = (byte)(48 + random.nextInt(10));
        }
        return byArray;
    }

    public static MimeContent parseMimeContent(String string, InputStream inputStream) throws Exception {
        String string2 = "multipart/form-data; boundary=";
        int n = string.indexOf(string2);
        if (n < 0) {
            throw new Error("Bad content type: [" + string + "]");
        }
        String string3 = string.substring(n + string2.length());
        MimeContent mimeContent = new MimeContent();
        mimeContent.parse(string3.getBytes("utf-8"), inputStream);
        return mimeContent;
    }

    protected String getMimeContentBeginErrorMessage(byte[] byArray, byte[] byArray2) {
        try {
            StringBuilder stringBuilder = new StringBuilder("MIME content doesn't begin with the appropriate delimiter.\n");
            if (byArray2 == null) {
                stringBuilder.append("\tBegin Marker is NULL\n");
            } else {
                stringBuilder.append("\tBegin Marker Bytes Size = ");
                stringBuilder.append(byArray2.length);
                stringBuilder.append("\n");
                if (byArray2.length > 0) {
                    stringBuilder.append("\tBegin Marker = [");
                    stringBuilder.append(new String(byArray2, "utf-8"));
                    stringBuilder.append("]\n");
                }
            }
            if (byArray == null) {
                stringBuilder.append("\tRaw Data is NULL\n");
            } else {
                stringBuilder.append("\tRaw Data Bytes Size = ");
                stringBuilder.append(byArray.length);
                stringBuilder.append("\n");
                if (byArray.length > 0) {
                    String string = new String(byArray, "utf-8");
                    int n = Math.min(120, string.length());
                    stringBuilder.append("\tRaw Data Begin = [");
                    stringBuilder.append(string.substring(0, n));
                    stringBuilder.append("]\n");
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            ErrorUtils.checkSwallow(throwable);
            return "MIME content doesn't begin with the appropriate delimiter.\n";
        }
    }

    protected String getMimeContentEndErrorMessage(byte[] byArray, byte[] byArray2) {
        try {
            StringBuilder stringBuilder = new StringBuilder("MIME content doesn't end with the appropriate delimiter.\n");
            if (byArray2 == null) {
                stringBuilder.append("\tEnd Marker is NULL\n");
            } else {
                stringBuilder.append("\tEnd Marker Bytes Size = ");
                stringBuilder.append(byArray2.length);
                stringBuilder.append("\n");
                if (byArray2.length > 0) {
                    stringBuilder.append("\tEnd Marker = [");
                    stringBuilder.append(new String(byArray2, "utf-8"));
                    stringBuilder.append("]\n");
                }
            }
            if (byArray == null) {
                stringBuilder.append("\tRaw Data is NULL\n");
            } else {
                stringBuilder.append("\tRaw Data Bytes Size = ");
                stringBuilder.append(byArray.length);
                stringBuilder.append("\n");
                if (byArray.length > 0) {
                    String string = new String(byArray, "utf-8");
                    int n = Math.min(120, string.length());
                    stringBuilder.append("\tRaw Data End = [");
                    stringBuilder.append(string.substring(string.length() - n));
                    stringBuilder.append("]\n");
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            ErrorUtils.checkSwallow(throwable);
            return "MIME content doesn't end with the appropriate delimiter.\n";
        }
    }
}

