/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import pse.util.general.FileUtils;

public class ZipUtils {
    public static void unzip(byte[] byArray, File file) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ZipUtils.unzip(byteArrayInputStream, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream inputStream, File file) throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipUtils.unzip(zipInputStream, file);
        }
        finally {
            zipInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(ZipInputStream zipInputStream, File file) throws Exception {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String string = zipEntry.getName();
            File file2 = new File(file, string);
            if (zipEntry.isDirectory()) {
                file2.mkdirs();
            } else {
                file2.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    byte[] byArray = new byte[64000];
                    while (zipInputStream.available() > 0) {
                        int n = zipInputStream.read(byArray, 0, byArray.length);
                        if (n <= 0) continue;
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                finally {
                    fileOutputStream.close();
                }
            }
            try {
                zipEntry = zipInputStream.getNextEntry();
            }
            catch (Exception exception) {
                zipEntry = null;
            }
        }
    }

    public static void unzip(File file, File file2) throws Exception {
        ZipUtils.unzip(new FileInputStream(file), file2);
    }

    public static ZipEntry findEntry(ZipFile zipFile, String string) throws Exception {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().equals(string)) continue;
            return zipEntry;
        }
        return null;
    }

    public static Map readEntryMap(ZipFile zipFile) throws Exception {
        HashMap<String, ZipEntry> hashMap = new HashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            hashMap.put(zipEntry.getName(), zipEntry);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntry(ZipFile zipFile, ZipEntry zipEntry) throws Exception {
        String string = null;
        Reader reader = null;
        try {
            reader = new InputStreamReader(zipFile.getInputStream(zipEntry));
            string = FileUtils.readFile(reader).toString();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return string;
    }

    public static String readEntry(ZipFile zipFile, String string) throws Exception {
        return ZipUtils.readEntry(zipFile, ZipUtils.findEntry(zipFile, string));
    }
}

