/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils2 {
    public static String getAttribute(Node node, String string) {
        if (node == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItem(string);
        return node2 == null ? null : node2.getNodeValue();
    }

    public static boolean getBooleanAttribute(Node node, String string, boolean bl) {
        String string2 = XMLUtils2.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return bl;
        }
        if (string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes")) {
            return true;
        }
        if (string2.equalsIgnoreCase("f") || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("n") || string2.equalsIgnoreCase("no")) {
            return false;
        }
        return bl;
    }

    public static Node getChild(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static String getChildText(Node node, String string) {
        return XMLUtils2.getChildText(node, string, "");
    }

    public static String getChildText(Node node, String string, String string2) {
        return XMLUtils2.getText(XMLUtils2.getChild(node, string), string2);
    }

    public static Element getElementChild(Node node, String string) {
        return (Element)XMLUtils2.getChild(node, string);
    }

    public static List<Element> getElementChildren(Node node) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            arrayList.add((Element)nodeList.item(i));
        }
        return arrayList;
    }

    public static List<Element> getElementChildren(Node node, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !(element = (Element)nodeList.item(i)).getNodeName().equals(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    public static int getIntAttribute(Node node, String string, int n) {
        String string2 = XMLUtils2.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            n2 = n;
        }
        return n2;
    }

    public static long getLongAttribute(Node node, String string, long l) {
        String string2 = XMLUtils2.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return l;
        }
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string2);
        }
        catch (Throwable throwable) {
            l2 = l;
        }
        return l2;
    }

    public static Boolean getNullBooleanAttribute(Node node, String string) {
        String string2 = XMLUtils2.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return null;
        }
        if (string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (string2.equalsIgnoreCase("f") || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("n") || string2.equalsIgnoreCase("no")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static List<Node> getNodeChildren(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    public static List<Node> getNodeChildren(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static String getNodeName(Node node) {
        return node == null ? null : node.getNodeName();
    }

    public static String getOptionalAttribute(Node node, String string, String string2) {
        String string3 = XMLUtils2.getAttribute(node, string);
        if (string3 == null || string3.trim().length() == 0) {
            return string2;
        }
        return string3;
    }

    public static String getOptionalChildText(Node node, String string) {
        return XMLUtils2.getText(XMLUtils2.getChild(node, string));
    }

    public static long getOptionalChildTextAsLong(Node node, String string, long l) {
        String string2 = XMLUtils2.getOptionalChildText(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return l;
        }
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string2);
        }
        catch (Throwable throwable) {
            l2 = l;
        }
        return l2;
    }

    public static boolean getOptionalYesNoAttribute(Node node, String string, boolean bl) {
        String string2 = XMLUtils2.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return bl;
        }
        return string2.equalsIgnoreCase("yes");
    }

    public static String getText(Node node) {
        return XMLUtils2.getText(node, "");
    }

    public static String getText(Node node, String string) {
        if (node == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3 && nodeList.item(i).getNodeType() != 4) continue;
            stringBuilder.append(((CharacterData)nodeList.item(i)).getData());
        }
        return stringBuilder.toString();
    }

    public static String getTransitiveText(Node node) {
        if (node == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() == 3 || nodeList.item(i).getNodeType() == 4) {
                stringBuilder.append(((CharacterData)nodeList.item(i)).getData());
                continue;
            }
            stringBuilder.append(XMLUtils2.getTransitiveText(nodeList.item(i)));
        }
        return stringBuilder.toString();
    }
}

