/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import panther.util.general.DOMPrinter;
import panther.util.general.ErrorUtils;
import pse.util.general.ApplicationError;
import pse.util.general.XmlEntityResolver;
import pse.util.general.XmlParsingErrorHandler;

public class XMLUtils {
    public static String getValue(Attributes attributes, String string) {
        return XMLUtils.getValue(attributes, string, null);
    }

    public static String getValue(Attributes attributes, String string, String string2) {
        String string3 = attributes.getValue(string);
        return string3 == null || string3.length() == 0 ? string2 : string3;
    }

    public static void clear(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        while (nodeList.getLength() > 0) {
            node.removeChild(nodeList.item(0));
        }
    }

    public static void parse(String string, DefaultHandler defaultHandler) throws Exception {
        XMLUtils.parse(new InputSource(new File(string).toURL().toString()), defaultHandler);
    }

    public static void parse(InputSource inputSource, DefaultHandler defaultHandler) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputSource, defaultHandler);
    }

    public static Node safeParse(String string) {
        Node node = null;
        try {
            node = XMLUtils.myParse(string);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            ErrorUtils.swallow("XMLUtils.safeParse()", throwable);
        }
        return node;
    }

    public static Node myParse(String string) {
        Node node = null;
        try {
            node = XMLUtils.parseToNode(string);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new ApplicationError.XMLSyntax(ErrorUtils.stackTrace(throwable));
        }
        return node;
    }

    public static DocumentBuilder createDocumentBuilder() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static Document parse(String string) throws Exception {
        return XMLUtils.parse(new FileInputStream(string));
    }

    public static Document parse(InputStream inputStream) throws Exception {
        return XMLUtils.parse(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(Reader reader) throws Exception {
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder();
        InputSource inputSource = new InputSource(reader);
        Document document = null;
        try {
            document = documentBuilder.parse(inputSource);
        }
        finally {
            reader.close();
        }
        return document;
    }

    public static Node parseToNode(String string) throws Exception {
        return XMLUtils.parseToNode(new StringReader(string));
    }

    public static Node parseToNode(Reader reader) throws Exception {
        return XMLUtils.parseToDocument(reader).getDocumentElement();
    }

    public static Document parseToDocument(String string) throws Exception {
        return XMLUtils.parseToDocument(new StringReader(string));
    }

    public static Document parseToDocument(Reader reader) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new XmlEntityResolver());
        Document document = documentBuilder.parse(new InputSource(reader));
        return document;
    }

    public static Document parseToDocument(String string, String string2) throws Exception {
        return XMLUtils.parseToDocument(string, new StringReader(string2));
    }

    public static Document parseToDocument(String string, Reader reader) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new XmlEntityResolver());
        Document document = documentBuilder.parse(new InputSource(reader));
        return document;
    }

    public static Document parseToDocument(String string, Reader reader, boolean bl) throws Exception {
        return XMLUtils.parseToDocument(reader, bl, new XmlParsingErrorHandler(string), new XmlEntityResolver());
    }

    public static Document parseToDocument(Reader reader, boolean bl, ErrorHandler errorHandler, EntityResolver entityResolver) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (errorHandler != null) {
            documentBuilder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        Document document = documentBuilder.parse(new InputSource(reader));
        return document;
    }

    public static Node parseToNode(String string, String string2) throws Exception {
        return XMLUtils.parseToNode(string, new StringReader(string2));
    }

    public static Node parseToNode(String string, Reader reader) throws Exception {
        return XMLUtils.parseToDocument(string, reader).getDocumentElement();
    }

    public static String print(Node node) {
        return DOMPrinter.nodeString(node);
    }

    public static void printToFile(Node node, String string) throws Exception {
        FileWriter fileWriter = new FileWriter(string);
        XMLUtils.print(node, fileWriter);
        ((Writer)fileWriter).close();
    }

    public static void print(Node node, Writer writer) throws Exception {
        DOMPrinter dOMPrinter = new DOMPrinter(node);
        dOMPrinter.print(node, writer);
    }

    public static String print(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(XMLUtils.print((Node)list.get(i)));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String getIMSText(Node node) {
        return XMLUtils.getDirectText(node, "LANGSTRING");
    }

    public static List getIMSText(List list) {
        if (list == null) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(XMLUtils.getIMSText((Node)list.get(i)));
        }
        return arrayList;
    }

    public static Attr getAttr(Node node, String string) {
        if (node == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        return namedNodeMap == null ? null : (Attr)namedNodeMap.getNamedItem(string);
    }

    public static String getAttributeValue(Node node, String string) {
        Node node2;
        String string2 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return string2;
    }

    public static String getAttribute(Node node, String string) {
        return node == null ? null : XMLUtils.getAttributeValue(node, string);
    }

    public static String getAttribute(Node node, String string, String string2) {
        String string3 = XMLUtils.getAttribute(node, string);
        return string3 != null ? string3 : string2;
    }

    public static boolean getBooleanAttribute(Node node, String string, boolean bl) {
        String string2 = XMLUtils.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return bl;
        }
        if (string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes")) {
            return true;
        }
        if (string2.equalsIgnoreCase("f") || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("n") || string2.equalsIgnoreCase("no")) {
            return false;
        }
        return bl;
    }

    public static double getDoubleAttribute(Node node, String string, double d) {
        String string2 = XMLUtils.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return d;
        }
        double d2 = 0.0;
        try {
            d2 = Double.parseDouble(string2);
        }
        catch (Throwable throwable) {
            d2 = d;
        }
        return d2;
    }

    public static int getIntAttribute(Node node, String string, int n) {
        String string2 = XMLUtils.getAttribute(node, string);
        if (string2 == null || string2.trim().length() == 0) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            n2 = n;
        }
        return n2;
    }

    public static void setAttribute(Node node, String string, String string2) {
        if (node == null) {
            return;
        }
        Attr attr = XMLUtils.getAttr(node, string);
        if (attr != null) {
            attr.setValue(string2);
        }
    }

    public static List getNamedChildren(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static Node getNamedChild(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static Node getChild(Node node, String string) {
        return node == null ? null : XMLUtils.getNamedChild(node, string);
    }

    public static Node getChildNamed(Node node, String string) {
        if (node == null) {
            return null;
        }
        List list = XMLUtils.getNamedChildren(node, string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (Node)list.get(0);
    }

    public static String getCData(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof CharacterData)) continue;
            stringBuffer.append(((CharacterData)node2).getData());
        }
        return stringBuffer.toString();
    }

    public static String getDirectText(Node node) {
        if (node == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3 && nodeList.item(i).getNodeType() != 4) continue;
            stringBuffer.append(((CharacterData)nodeList.item(i)).getData());
        }
        return stringBuffer.toString();
    }

    public static String getDirectText(Node node, String string) {
        return XMLUtils.getDirectText(XMLUtils.getChild(node, string));
    }

    public static String getTransitiveText(Node node) {
        if (node == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() == 3 || nodeList.item(i).getNodeType() == 4) {
                stringBuffer.append(((CharacterData)nodeList.item(i)).getData());
                continue;
            }
            stringBuffer.append(XMLUtils.getTransitiveText(nodeList.item(i)));
        }
        return stringBuffer.toString();
    }

    public static String getTransitiveText(Node node, String string) {
        return XMLUtils.getTransitiveText(XMLUtils.getChild(node, string));
    }

    public static List getDirectText(List list) {
        if (list == null) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(XMLUtils.getDirectText((Node)list.get(i)));
        }
        return arrayList;
    }

    public static List getChildren(Node node, String string) {
        return node == null ? new ArrayList() : XMLUtils.getNamedChildren(node, string);
    }

    public static List getChildren(Node node) {
        if (node == null) {
            return new ArrayList();
        }
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    public static List getChildrensAttributes(Node node, String string, String string2) {
        List list = XMLUtils.getChildren(node, string);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Node node2 = (Node)list.get(i);
            arrayList.add(XMLUtils.getAttribute(node2, string2));
        }
        return arrayList;
    }

    public static Node getChild(Node node, String string, String string2, String string3) {
        List list = XMLUtils.getChildren(node, string);
        for (int i = 0; i < list.size(); ++i) {
            Node node2 = (Node)list.get(i);
            String string4 = XMLUtils.getAttribute(node2, string2);
            if (string4 == null || !string3.equalsIgnoreCase(string4)) continue;
            return node2;
        }
        return null;
    }

    public static List getElementChildren(Node node) {
        if (node == null) {
            return new ArrayList();
        }
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    public static void replaceChild(Node node, Node node2, Node node3) {
        node.replaceChild(node3, node2);
    }

    public static String cdata(char c) {
        return "<![CDATA[" + XMLUtils.escapeCData(c) + "]]>";
    }

    public static String cdata(String string) {
        return "<![CDATA[" + XMLUtils.escapeCData(string) + "]]>";
    }

    public static String cdata(String string, String string2) {
        return string2 + "<![CDATA[\n" + XMLUtils.escapeCData(string) + "\n" + string2 + "]]>";
    }

    public static String escape(char c) {
        if (c <= '\u001f') {
            return XMLUtils.escapeLowCharacter(c);
        }
        if (c == '&') {
            return "&amp;";
        }
        if (c == '>') {
            return "&gt;";
        }
        if (c == '<') {
            return "&lt;";
        }
        if (c == '\"') {
            return "\\\"";
        }
        return String.valueOf(c);
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(XMLUtils.escape(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String escapeCData(char c) {
        if (c <= '\u001f') {
            return XMLUtils.escapeLowCharacter(c);
        }
        return String.valueOf(c);
    }

    public static String escapeCData(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(XMLUtils.escapeCData(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String escapeLowCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(XMLUtils.escapeLowCharacter(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static void writeXmlFile(Document document, String string) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(string);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public static String escapeLowCharacter(char c) {
        if (c == '\n') {
            return "\n";
        }
        if (c == '\t') {
            return "\t";
        }
        if (c == '\u0000') {
            return "^0";
        }
        if (c == '\u0001') {
            return "^A";
        }
        if (c == '\u0002') {
            return "^B";
        }
        if (c == '\u0003') {
            return "^C";
        }
        if (c == '\u0004') {
            return "^D";
        }
        if (c == '\u0005') {
            return "^E";
        }
        if (c == '\u0006') {
            return "^F";
        }
        if (c == '\u0007') {
            return "^G";
        }
        if (c == '\b') {
            return "^H";
        }
        if (c == '\t') {
            return "^I";
        }
        if (c == '\n') {
            return "^J";
        }
        if (c == '\u000b') {
            return "^K";
        }
        if (c == '\f') {
            return "^L";
        }
        if (c == '\r') {
            return "";
        }
        if (c == '\u000e') {
            return "^N";
        }
        if (c == '\u000f') {
            return "^O";
        }
        if (c == '\u0010') {
            return "^P";
        }
        if (c == '\u0011') {
            return "^Q";
        }
        if (c == '\u0012') {
            return "^R";
        }
        if (c == '\u0013') {
            return "^S";
        }
        if (c == '\u0014') {
            return "^T";
        }
        if (c == '\u0015') {
            return "^U";
        }
        if (c == '\u0016') {
            return "^V";
        }
        if (c == '\u0017') {
            return "^W";
        }
        if (c == '\u0018') {
            return "^X";
        }
        if (c == '\u0019') {
            return "^Y";
        }
        if (c == '\u001a') {
            return "^X";
        }
        if (c == '\u001b') {
            return "^1";
        }
        if (c == '\u001c') {
            return "^2";
        }
        if (c == '\u001d') {
            return "^3";
        }
        if (c == '\u001e') {
            return "^4";
        }
        if (c == '\u001f') {
            return "^5";
        }
        return String.valueOf(c);
    }
}

