/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SortedList {
    protected List contents;
    protected Comparator comparator;

    public SortedList() {
        this.contents = new ArrayList();
        this.useNaturalSort();
    }

    public SortedList(int n) {
        this.contents = new ArrayList(n);
        this.useNaturalSort();
    }

    public SortedList(Collection collection) {
        this.contents = new ArrayList(collection);
        this.useNaturalSort();
        this.reSort();
    }

    public SortedList(Comparator comparator) {
        this.contents = new ArrayList();
        this.comparator = comparator;
    }

    public SortedList(Collection collection, Comparator comparator) {
        this.contents = new ArrayList(collection);
        this.comparator = comparator;
        this.reSort();
    }

    public boolean contains(Object object) {
        return this.contents.contains(object);
    }

    public void addAll(SortedList sortedList) {
        this.addAll(sortedList.getContents());
    }

    public void clear() {
        this.contents.clear();
    }

    public void useNaturalSort() {
        this.comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Comparable)object).compareTo((Comparable)object2);
            }
        };
    }

    public void reSort() {
        Collections.sort(this.contents, this.comparator);
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.reSort();
    }

    public String toString() {
        return "Sorted" + this.contents;
    }

    public List getContents() {
        return this.contents;
    }

    public Object get(int n) {
        return this.contents.get(n);
    }

    public int size() {
        return this.contents.size();
    }

    public Object remove(int n) {
        Object object = this.get(n);
        this.contents.remove(n);
        return object;
    }

    public int remove(Object object) {
        int n = this.indexOf(object);
        this.remove(n);
        return n;
    }

    public int indexOf(Object object) {
        return this.contents.indexOf(object);
    }

    public int add(Object object) {
        int n = this.indexForInserting(object);
        this.contents.add(n, object);
        return n;
    }

    public void addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    protected int indexForInserting(Object object) {
        for (int i = 0; i < this.contents.size(); ++i) {
            int n = this.comparator.compare(object, this.get(i));
            if (n >= 0) continue;
            return i;
        }
        return this.contents.size();
    }
}

