/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import panther.util.general.Pair;

public class Relation {
    protected Set pairs = new HashSet();

    public void add(Object object, Object object2) {
        this.pairs.add(new Pair(object, object2));
    }

    public boolean contains(Object object, Object object2) {
        return this.pairs.contains(new Pair(object, object2));
    }

    public void removeIdentities() {
        Iterator iterator = this.pairs.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (!pair.isIdentity()) continue;
            iterator.remove();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Relation (");
        stringBuffer.append(this.pairs.size());
        stringBuffer.append(")\n");
        for (Pair pair : this.pairs) {
            stringBuffer.append("\t( ");
            stringBuffer.append(pair.getFirst());
            stringBuffer.append(" , ");
            stringBuffer.append(pair.getSecond());
            stringBuffer.append(")\n");
        }
        return stringBuffer.toString();
    }

    public void computeTransitiveClosure() {
        ArrayList<Pair> arrayList = new ArrayList<Pair>(this.pairs);
        boolean bl = false;
        do {
            bl = false;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Pair pair = (Pair)arrayList.get(i);
                for (int j = i + 1; j < n; ++j) {
                    Pair pair2 = (Pair)arrayList.get(j);
                    Pair pair3 = pair.merge(pair2);
                    if (pair3 == null || arrayList.contains(pair3)) continue;
                    arrayList.add(pair3);
                    bl = true;
                }
            }
        } while (bl);
        this.pairs = new HashSet(arrayList);
    }
}

