/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import panther.util.general.Argumatic;
import panther.util.general.DevOut;

public class RawSocketClient
implements Runnable {
    private int port = 80;
    private String server = "localhost";
    private boolean help = false;
    private Socket socket = null;

    public static void main(String[] stringArray) {
        RawSocketClient rawSocketClient = new RawSocketClient();
        rawSocketClient.doMain(stringArray);
    }

    private byte[] parseInput(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '#') {
                int n2 = ++n;
                if ((n += 2) <= string.length()) {
                    String string2 = string.substring(n2, n);
                    int n3 = Integer.parseInt(string2, 16);
                    byteArrayOutputStream.write(n3);
                    continue;
                }
                DevOut.println("Must specify #XX\n");
                continue;
            }
            byteArrayOutputStream.write((byte)c);
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void doMain(String[] stringArray) {
        Argumatic argumatic = new Argumatic(stringArray, this);
        if (argumatic.getArgCount() == 0 || this.help) {
            argumatic.displayUsage();
            return;
        }
        try {
            this.socket = new Socket(this.server, this.port);
        }
        catch (IOException iOException) {
            DevOut.println("Unable to connect: " + iOException.getMessage());
            return;
        }
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileDescriptor.in));
            OutputStream outputStream = this.socket.getOutputStream();
            while (true) {
                DevOut.print("% ");
                String string = bufferedReader.readLine();
                if (string == null) break;
                if (string.length() <= 0) continue;
                DevOut.println();
                byte[] byArray = this.parseInput(string);
                outputStream.write(byArray);
            }
            this.socket.close();
        }
        catch (IOException iOException) {
            DevOut.println("IO Error: " + iOException.getMessage());
        }
    }

    private void dump(byte[] byArray, int n) {
        char c;
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            c = byArray[n2];
            if (c <= '\n') {
                DevOut.print('0');
            }
            DevOut.print(Integer.toHexString(c));
            DevOut.print(' ');
        }
        DevOut.print(':');
        for (n2 = 0; n2 < n; ++n2) {
            c = '.';
            if (byArray[n2] >= 32 && byArray[n2] < 127) {
                c = (char)byArray[n2];
            }
            DevOut.print(c);
        }
        DevOut.println();
    }

    public void run() {
        try {
            InputStream inputStream = this.socket.getInputStream();
            byte[] byArray = new byte[16];
            while (true) {
                int n;
                if ((n = inputStream.read(byArray)) < 0) {
                    DevOut.println("EOF from socket");
                    break;
                }
                this.dump(byArray, n);
            }
        }
        catch (IOException iOException) {
            DevOut.println("IO Error reading from socket: " + iOException.getMessage());
        }
    }

    public void setServer(String string) {
        this.server = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public Argumatic.Meta getPortMeta() {
        return Argumatic.Meta.getIntMeta(null, 1, 65535);
    }
}

